/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.internal;

import java.util.Properties;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.ec2.compute.internal.BaseEC2ComputeServiceContextExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.annotations.BeforeClass;

public abstract class BaseEC2ComputeServiceExpectTest
extends BaseEC2ComputeServiceContextExpectTest<ComputeService> {
    protected String region = "us-east-1";
    protected HttpRequest describeAvailabilityZonesRequest;
    protected HttpResponse describeAvailabilityZonesResponse;
    protected HttpRequest describeImagesRequest;
    protected HttpResponse describeImagesResponse;
    protected HttpRequest createKeyPairRequest;
    protected HttpResponse createKeyPairResponse;
    protected HttpRequest createSecurityGroupRequest;
    protected HttpResponse createSecurityGroupResponse;
    protected HttpRequest describeSecurityGroupRequest;
    protected HttpResponse describeSecurityGroupResponse;
    protected HttpRequest authorizeSecurityGroupIngressRequest22;
    protected HttpResponse authorizeSecurityGroupIngressResponse;
    protected HttpRequest authorizeSecurityGroupIngressRequestGroup;
    protected HttpRequest runInstancesRequest;
    protected HttpResponse runInstancesResponse;
    protected HttpRequest describeInstanceRequest;
    protected HttpResponse describeInstanceResponse;
    protected HttpRequest describeInstanceMultiIdsRequest;
    protected HttpResponse describeInstanceMultiIdsResponse;
    protected HttpRequest describeImageRequest;

    protected Properties setupProperties() {
        Properties properties = super.setupProperties();
        properties.setProperty("jclouds.regions", this.region);
        properties.setProperty(this.provider + ".template", "osDescriptionMatches=.*fedora.*");
        return properties;
    }

    @Override
    @BeforeClass
    protected void setupDefaultRequests() {
        super.setupDefaultRequests();
        this.describeAvailabilityZonesRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeAvailabilityZones"}).build());
        this.describeAvailabilityZonesResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/availabilityZones-" + this.region + ".xml", "application/xml"))).build();
        this.describeImagesRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeImages"}).build());
        this.describeImagesResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_images.xml", "application/xml"))).build();
        this.createKeyPairRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"CreateKeyPair"}).addFormParam("KeyName", new String[]{"jclouds#test#0"}).build());
        this.createKeyPairResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/create_keypair.xml", "application/xml"))).build();
        this.createSecurityGroupRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"CreateSecurityGroup"}).addFormParam("GroupDescription", new String[]{"jclouds#test"}).addFormParam("GroupName", new String[]{"jclouds#test"}).build());
        this.createSecurityGroupResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/created_securitygroup.xml", "application/xml"))).build();
        this.describeSecurityGroupRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeSecurityGroups"}).addFormParam("GroupName.1", new String[]{"jclouds#test"}).build());
        this.describeSecurityGroupResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/new_securitygroup.xml", "application/xml"))).build();
        this.authorizeSecurityGroupIngressRequest22 = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"AuthorizeSecurityGroupIngress"}).addFormParam("CidrIp", new String[]{"0.0.0.0/0"}).addFormParam("FromPort", new String[]{"22"}).addFormParam("ToPort", new String[]{"22"}).addFormParam("GroupName", new String[]{"jclouds#test"}).addFormParam("IpProtocol", new String[]{"tcp"}).build());
        this.authorizeSecurityGroupIngressRequestGroup = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"AuthorizeSecurityGroupIngress"}).addFormParam("SourceSecurityGroupName", new String[]{"jclouds#test"}).addFormParam("SourceSecurityGroupOwnerId", new String[]{"993194456877"}).addFormParam("GroupName", new String[]{"jclouds#test"}).build());
        this.authorizeSecurityGroupIngressResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/authorize_securitygroup_ingress_response.xml", "application/xml"))).build();
        this.runInstancesRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"RunInstances"}).addFormParam("ImageId", new String[]{"ami-be3adfd7"}).addFormParam("InstanceType", new String[]{"m1.small"}).addFormParam("KeyName", new String[]{"jclouds#test#0"}).addFormParam("MaxCount", new String[]{"1"}).addFormParam("MinCount", new String[]{"1"}).addFormParam("SecurityGroup.1", new String[]{"jclouds#test"}).build());
        this.runInstancesResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/new_instance.xml", "application/xml"))).build();
        this.describeInstanceRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeInstances"}).addFormParam("InstanceId.1", new String[]{"i-2baa5550"}).build());
        this.describeInstanceResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_instances_running-1.xml", "application/xml"))).build();
        this.describeInstanceMultiIdsRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeInstances"}).addFormParam("InstanceId.1", new String[]{"i-2baa5550"}).addFormParam("InstanceId.2", new String[]{"i-abcd1234"}).build());
        this.describeInstanceMultiIdsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_instances_multiple.xml", "application/xml"))).build();
        this.describeImageRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("ImageId.1", new String[]{"ami-aecd60c7"}).addFormParam("Action", new String[]{"DescribeImages"}).build());
    }

    public ComputeService apply(ComputeServiceContext input) {
        return input.getComputeService();
    }
}

