/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import org.easymock.EasyMock;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.strategy.EC2DestroyNodeStrategy;
import org.jclouds.ec2.services.ElasticIPAddressClient;
import org.jclouds.ec2.services.InstanceClient;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="EC2DestroyNodeStrategyTest")
public class EC2DestroyNodeStrategyTest {
    @Test
    public void testDestroyNodeTerminatesInstanceAndReturnsRefreshedNode() throws Exception {
        EC2Client client = (EC2Client)EasyMock.createMock(EC2Client.class);
        InstanceClient instanceClient = (InstanceClient)EasyMock.createMock(InstanceClient.class);
        GetNodeMetadataStrategy getNode = (GetNodeMetadataStrategy)EasyMock.createMock(GetNodeMetadataStrategy.class);
        LoadingCache elasticIpCache = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        NodeMetadata node = (NodeMetadata)EasyMock.createMock(NodeMetadata.class);
        EasyMock.expect((Object)client.getInstanceServices()).andReturn((Object)instanceClient).atLeastOnce();
        EasyMock.expect((Object)instanceClient.terminateInstancesInRegion("region", new String[]{"i-blah"})).andReturn(null);
        EasyMock.expect((Object)getNode.getNode("region/i-blah")).andReturn((Object)node);
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{getNode});
        EasyMock.replay((Object[])new Object[]{instanceClient});
        EasyMock.replay((Object[])new Object[]{elasticIpCache});
        EC2DestroyNodeStrategy destroyer = new EC2DestroyNodeStrategy(client, getNode, elasticIpCache);
        Assert.assertEquals((Object)destroyer.destroyNode("region/i-blah"), (Object)node);
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{getNode});
        EasyMock.verify((Object[])new Object[]{instanceClient});
        EasyMock.verify((Object[])new Object[]{elasticIpCache});
    }

    @Test
    public void testDestroyNodeDisassociatesAndReleasesIpThenTerminatesInstanceAndReturnsRefreshedNode() throws Exception {
        EC2Client client = (EC2Client)EasyMock.createMock(EC2Client.class);
        GetNodeMetadataStrategy getNode = (GetNodeMetadataStrategy)EasyMock.createMock(GetNodeMetadataStrategy.class);
        LoadingCache elasticIpCache = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        ElasticIPAddressClient ipClient = (ElasticIPAddressClient)EasyMock.createMock(ElasticIPAddressClient.class);
        InstanceClient instanceClient = (InstanceClient)EasyMock.createMock(InstanceClient.class);
        NodeMetadata node = (NodeMetadata)EasyMock.createMock(NodeMetadata.class);
        EasyMock.expect((Object)elasticIpCache.get((Object)new RegionAndName("region", "i-blah"))).andReturn((Object)"1.1.1.1");
        EasyMock.expect((Object)client.getElasticIPAddressServices()).andReturn((Object)ipClient).atLeastOnce();
        ipClient.disassociateAddressInRegion("region", "1.1.1.1");
        ipClient.releaseAddressInRegion("region", "1.1.1.1");
        elasticIpCache.invalidate((Object)new RegionAndName("region", "i-blah"));
        EasyMock.expect((Object)client.getInstanceServices()).andReturn((Object)instanceClient).atLeastOnce();
        EasyMock.expect((Object)instanceClient.terminateInstancesInRegion("region", new String[]{"i-blah"})).andReturn(null);
        EasyMock.expect((Object)getNode.getNode("region/i-blah")).andReturn((Object)node);
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{getNode});
        EasyMock.replay((Object[])new Object[]{elasticIpCache});
        EasyMock.replay((Object[])new Object[]{instanceClient});
        EasyMock.replay((Object[])new Object[]{ipClient});
        EC2DestroyNodeStrategy destroyer = new EC2DestroyNodeStrategy(client, getNode, elasticIpCache);
        destroyer.autoAllocateElasticIps = true;
        Assert.assertEquals((Object)destroyer.destroyNode("region/i-blah"), (Object)node);
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{getNode});
        EasyMock.verify((Object[])new Object[]{elasticIpCache});
        EasyMock.verify((Object[])new Object[]{instanceClient});
        EasyMock.verify((Object[])new Object[]{ipClient});
    }

    @Test
    public void testDestroyNodeSafeOnCacheMissThenTerminatesInstanceAndReturnsRefreshedNode() throws Exception {
        EC2Client client = (EC2Client)EasyMock.createMock(EC2Client.class);
        GetNodeMetadataStrategy getNode = (GetNodeMetadataStrategy)EasyMock.createMock(GetNodeMetadataStrategy.class);
        LoadingCache elasticIpCache = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        ElasticIPAddressClient ipClient = (ElasticIPAddressClient)EasyMock.createMock(ElasticIPAddressClient.class);
        InstanceClient instanceClient = (InstanceClient)EasyMock.createMock(InstanceClient.class);
        NodeMetadata node = (NodeMetadata)EasyMock.createMock(NodeMetadata.class);
        EasyMock.expect((Object)elasticIpCache.get((Object)new RegionAndName("region", "i-blah"))).andThrow((Throwable)new CacheLoader.InvalidCacheLoadException(null));
        EasyMock.expect((Object)client.getInstanceServices()).andReturn((Object)instanceClient).atLeastOnce();
        EasyMock.expect((Object)instanceClient.terminateInstancesInRegion("region", new String[]{"i-blah"})).andReturn(null);
        EasyMock.expect((Object)getNode.getNode("region/i-blah")).andReturn((Object)node);
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{getNode});
        EasyMock.replay((Object[])new Object[]{elasticIpCache});
        EasyMock.replay((Object[])new Object[]{instanceClient});
        EasyMock.replay((Object[])new Object[]{ipClient});
        EC2DestroyNodeStrategy destroyer = new EC2DestroyNodeStrategy(client, getNode, elasticIpCache);
        destroyer.autoAllocateElasticIps = true;
        Assert.assertEquals((Object)destroyer.destroyNode("region/i-blah"), (Object)node);
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{getNode});
        EasyMock.verify((Object[])new Object[]{elasticIpCache});
        EasyMock.verify((Object[])new Object[]{instanceClient});
        EasyMock.verify((Object[])new Object[]{ipClient});
    }

    @Test
    public void testDestroyNodeSafeOnCacheExecutionExceptionThenTerminatesInstanceAndReturnsRefreshedNode() throws Exception {
        EC2Client client = (EC2Client)EasyMock.createMock(EC2Client.class);
        GetNodeMetadataStrategy getNode = (GetNodeMetadataStrategy)EasyMock.createMock(GetNodeMetadataStrategy.class);
        LoadingCache elasticIpCache = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        ElasticIPAddressClient ipClient = (ElasticIPAddressClient)EasyMock.createMock(ElasticIPAddressClient.class);
        InstanceClient instanceClient = (InstanceClient)EasyMock.createMock(InstanceClient.class);
        NodeMetadata node = (NodeMetadata)EasyMock.createMock(NodeMetadata.class);
        EasyMock.expect((Object)elasticIpCache.get((Object)new RegionAndName("region", "i-blah"))).andThrow((Throwable)new ExecutionException(null));
        EasyMock.expect((Object)client.getInstanceServices()).andReturn((Object)instanceClient).atLeastOnce();
        EasyMock.expect((Object)instanceClient.terminateInstancesInRegion("region", new String[]{"i-blah"})).andReturn(null);
        EasyMock.expect((Object)getNode.getNode("region/i-blah")).andReturn((Object)node);
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{getNode});
        EasyMock.replay((Object[])new Object[]{elasticIpCache});
        EasyMock.replay((Object[])new Object[]{instanceClient});
        EasyMock.replay((Object[])new Object[]{ipClient});
        EC2DestroyNodeStrategy destroyer = new EC2DestroyNodeStrategy(client, getNode, elasticIpCache);
        destroyer.autoAllocateElasticIps = true;
        Assert.assertEquals((Object)destroyer.destroyNode("region/i-blah"), (Object)node);
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{getNode});
        EasyMock.verify((Object[])new Object[]{elasticIpCache});
        EasyMock.verify((Object[])new Object[]{instanceClient});
        EasyMock.verify((Object[])new Object[]{ipClient});
    }
}

