/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.Subnet;
import org.jclouds.ec2.features.SubnetApi;
import org.jclouds.ec2.internal.BaseEC2ApiLiveTest;
import org.jclouds.ec2.util.SubnetFilterBuilder;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class SubnetApiLiveTest
extends BaseEC2ApiLiveTest {
    private void checkSubnet(Subnet subnet) {
        Logger.getAnonymousLogger().info(String.format("subnet %s vpc: %s", subnet.getSubnetId(), subnet.getVpcId()));
        Preconditions.checkNotNull((Object)subnet.getSubnetId(), (String)"Id: Subnet %s", (Object[])new Object[]{subnet});
        Preconditions.checkNotNull((Object)subnet.getVpcId(), (String)"VPC: Subnet %s", (Object[])new Object[]{subnet});
        Preconditions.checkNotNull((Object)subnet.getSubnetState(), (String)"SubnetState: Subnet %s", (Object[])new Object[]{subnet});
        Preconditions.checkNotNull((Object)subnet.getCidrBlock(), (String)"CIDR Block: %s", (Object[])new Object[]{subnet});
        Preconditions.checkNotNull((Object)subnet.getAvailabilityZone(), (String)"Availability Zone: %s", (Object[])new Object[]{subnet});
    }

    @Test
    public void testListSubnets() {
        ImmutableSet subnets = this.api().list().toSet();
        Logger.getAnonymousLogger().info("subnets: " + subnets.size());
        for (Subnet subnet : subnets) {
            this.checkSubnet(subnet);
            Assert.assertEquals((Object)this.api().filter((Multimap)new SubnetFilterBuilder().subnetId(subnet.getSubnetId()).build()).get(0), (Object)subnet);
        }
    }

    @Test
    public void testFilterWhenNotFound() {
        Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<Iterable<Subnet>>(){

            public boolean apply(Iterable<Subnet> input) {
                return SubnetApiLiveTest.this.api().filter((Multimap)new SubnetFilterBuilder().subnetId("subnet-pants").build()).toSet().equals(input);
            }
        }, (long)600L, (long)200L, (long)200L, (TimeUnit)TimeUnit.MILLISECONDS).apply((Object)ImmutableSet.of()));
    }

    private SubnetApi api() {
        Optional subnetOption = ((EC2Api)this.api).getSubnetApi();
        if (!subnetOption.isPresent()) {
            throw new SkipException("subnet api not present");
        }
        return (SubnetApi)subnetOption.get();
    }
}

