/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.features.TagApi;
import org.jclouds.ec2.internal.BaseEC2ApiExpectTest;
import org.jclouds.ec2.parse.DescribeTagsResponseTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class TagApiExpectTest
extends BaseEC2ApiExpectTest<EC2Api> {
    HttpRequest apply = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).payload(TagApiExpectTest.payloadFromStringWithContentType((String)"Action=CreateTags&ResourceId.1=i-43532&Signature=Trp5e5%2BMqeBeBZbLYa9s9gxahQ9nkx6ETfsGl82IV8Y%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Tag.1.Key=tag&Tag.1.Value=&Timestamp=2012-04-16T15%3A54%3A08.897Z&Version=2010-08-31&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build();
    HttpRequest applyWithValues = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).payload(TagApiExpectTest.payloadFromStringWithContentType((String)"Action=CreateTags&ResourceId.1=i-43532&Signature=jwCQr50j%2BvGkav4t0BN0G8RmNJ7VaFK6/7N/HKUmHL8%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Tag.1.Key=tag&Tag.1.Value=value&Timestamp=2012-04-16T15%3A54%3A08.897Z&Version=2010-08-31&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build();
    HttpRequest list = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).payload(TagApiExpectTest.payloadFromStringWithContentType((String)"Action=DescribeTags&Signature=DYUjPGiRl9copBtmpocMZYVAy4OTrK2AJzcAH5QiBuw%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Timestamp=2012-04-16T15%3A54%3A08.897Z&Version=2010-08-31&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build();
    HttpRequest filter = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).payload(TagApiExpectTest.payloadFromStringWithContentType((String)"Action=DescribeTags&Filter.1.Name=resource-type&Filter.1.Value.1=instance&Filter.2.Name=key&Filter.2.Value.1=stack&Signature=doNEEZHEzXV/SD2eSZ6PpB1PADcsAF99lXGvsh3MbS4%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Timestamp=2012-04-16T15%3A54%3A08.897Z&Version=2010-08-31&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build();
    HttpRequest delete = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).payload(TagApiExpectTest.payloadFromStringWithContentType((String)"Action=DeleteTags&ResourceId.1=i-43532&Signature=ytM605menR00re60wXMgBDpozrQCi0lVupf755/Mpck%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Tag.1.Key=tag&Timestamp=2012-04-16T15%3A54%3A08.897Z&Version=2010-08-31&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build();
    HttpRequest conditionallyDelete = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).payload(TagApiExpectTest.payloadFromStringWithContentType((String)"Action=DeleteTags&ResourceId.1=i-43532&Signature=vRvgPegVDDjIEKudZ5Tpck0GQrVts//1jzk4W5RgI9k%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Tag.1.Key=tag&Tag.1.Value=value&Timestamp=2012-04-16T15%3A54%3A08.897Z&Version=2010-08-31&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build();

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        props.put("jclouds.api-version", "2010-08-31");
        return props;
    }

    public void testApplyWhenResponseIs2xx() throws Exception {
        HttpResponse applyResponse = HttpResponse.builder().statusCode(200).build();
        EC2Api apiWhenExist = (EC2Api)this.requestSendsResponse(this.apply, applyResponse);
        ((TagApi)apiWhenExist.getTagApi().get()).applyToResources((Iterable)ImmutableSet.of((Object)"tag"), (Iterable)ImmutableSet.of((Object)"i-43532"));
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testApplyWhenResponseIs404() throws Exception {
        HttpResponse applyResponse = HttpResponse.builder().statusCode(404).build();
        EC2Api apiWhenDontExist = (EC2Api)this.requestSendsResponse(this.apply, applyResponse);
        ((TagApi)apiWhenDontExist.getTagApi().get()).applyToResources((Iterable)ImmutableSet.of((Object)"tag"), (Iterable)ImmutableSet.of((Object)"i-43532"));
    }

    public void testApplyWithValuesWhenResponseIs2xx() throws Exception {
        HttpResponse applyResponse = HttpResponse.builder().statusCode(200).build();
        EC2Api apiWhenExist = (EC2Api)this.requestSendsResponse(this.applyWithValues, applyResponse);
        ((TagApi)apiWhenExist.getTagApi().get()).applyToResources((Map)ImmutableMap.of((Object)"tag", (Object)"value"), (Iterable)ImmutableSet.of((Object)"i-43532"));
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testApplyWithValuesWhenResponseIs404() throws Exception {
        HttpResponse applyResponse = HttpResponse.builder().statusCode(404).build();
        EC2Api apiWhenDontExist = (EC2Api)this.requestSendsResponse(this.applyWithValues, applyResponse);
        ((TagApi)apiWhenDontExist.getTagApi().get()).applyToResources((Map)ImmutableMap.of((Object)"tag", (Object)"value"), (Iterable)ImmutableSet.of((Object)"i-43532"));
    }

    public void testListWhenResponseIs2xx() throws Exception {
        HttpResponse listResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_tags.xml", "text/xml"))).build();
        EC2Api apiWhenExist = (EC2Api)this.requestSendsResponse(this.list, listResponse);
        Assert.assertEquals((String)((TagApi)apiWhenExist.getTagApi().get()).list().toString(), (String)new DescribeTagsResponseTest().expected().toString());
    }

    public void testListWhenResponseIs404() throws Exception {
        HttpResponse listResponse = HttpResponse.builder().statusCode(404).build();
        EC2Api apiWhenDontExist = (EC2Api)this.requestSendsResponse(this.list, listResponse);
        Assert.assertEquals((Set)((TagApi)apiWhenDontExist.getTagApi().get()).list().toSet(), (Set)ImmutableSet.of());
    }

    public void testFilterWhenResponseIs2xx() throws Exception {
        HttpResponse filterResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_tags.xml", "text/xml"))).build();
        EC2Api apiWhenExist = (EC2Api)this.requestSendsResponse(this.filter, filterResponse);
        Assert.assertEquals((String)((TagApi)apiWhenExist.getTagApi().get()).filter((Multimap)ImmutableMultimap.builder().put((Object)"resource-type", (Object)"instance").put((Object)"key", (Object)"stack").build()).toString(), (String)new DescribeTagsResponseTest().expected().toString());
    }

    public void testFilterWhenResponseIs404() throws Exception {
        HttpResponse filterResponse = HttpResponse.builder().statusCode(404).build();
        EC2Api apiWhenDontExist = (EC2Api)this.requestSendsResponse(this.filter, filterResponse);
        Assert.assertEquals((Set)((TagApi)apiWhenDontExist.getTagApi().get()).filter((Multimap)ImmutableMultimap.builder().put((Object)"resource-type", (Object)"instance").put((Object)"key", (Object)"stack").build()).toSet(), (Set)ImmutableSet.of());
    }

    public void testDeleteWhenResponseIs2xx() throws Exception {
        HttpResponse deleteResponse = HttpResponse.builder().statusCode(200).build();
        EC2Api apiWhenExist = (EC2Api)this.requestSendsResponse(this.delete, deleteResponse);
        ((TagApi)apiWhenExist.getTagApi().get()).deleteFromResources((Iterable)ImmutableSet.of((Object)"tag"), (Iterable)ImmutableSet.of((Object)"i-43532"));
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testDeleteWhenResponseIs404() throws Exception {
        HttpResponse deleteResponse = HttpResponse.builder().statusCode(404).build();
        EC2Api apiWhenDontExist = (EC2Api)this.requestSendsResponse(this.delete, deleteResponse);
        ((TagApi)apiWhenDontExist.getTagApi().get()).deleteFromResources((Iterable)ImmutableSet.of((Object)"tag"), (Iterable)ImmutableSet.of((Object)"i-43532"));
    }

    public void testConditionallyDeleteWhenResponseIs2xx() throws Exception {
        HttpResponse conditionallyDeleteResponse = HttpResponse.builder().statusCode(200).build();
        EC2Api apiWhenExist = (EC2Api)this.requestSendsResponse(this.conditionallyDelete, conditionallyDeleteResponse);
        ((TagApi)apiWhenExist.getTagApi().get()).conditionallyDeleteFromResources((Map)ImmutableMap.of((Object)"tag", (Object)"value"), (Iterable)ImmutableSet.of((Object)"i-43532"));
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testConditionallyDeleteWhenResponseIs404() throws Exception {
        HttpResponse conditionallyDeleteResponse = HttpResponse.builder().statusCode(404).build();
        EC2Api apiWhenDontExist = (EC2Api)this.requestSendsResponse(this.conditionallyDelete, conditionallyDeleteResponse);
        ((TagApi)apiWhenDontExist.getTagApi().get()).conditionallyDeleteFromResources((Map)ImmutableMap.of((Object)"tag", (Object)"value"), (Iterable)ImmutableSet.of((Object)"i-43532"));
    }
}

