/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.internal;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import java.util.Map;
import java.util.TimeZone;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.internal.BaseRestClientExpectTest;
import org.testng.annotations.BeforeClass;

public abstract class BaseEC2ExpectTest<T>
extends BaseRestClientExpectTest<T> {
    protected static final String CONSTANT_DATE = "2012-04-16T15:54:08.897Z";
    protected DateService dateService = new SimpleDateFormatDateService();
    protected FormSigner formSigner;
    protected HttpRequest describeRegionsRequest;
    protected HttpResponse describeRegionsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/regionEndpoints-all.xml", "application/xml"))).build();
    protected Map<HttpRequest, HttpResponse> describeAvailabilityZonesRequestResponse;

    public BaseEC2ExpectTest() {
        this.provider = "ec2";
        TimeZone.setDefault(TimeZone.getTimeZone("America/Los_Angeles"));
    }

    @BeforeClass
    protected void setupDefaultRequests() {
        Injector injector = this.createInjector(Functions.forMap((Map)ImmutableMap.of()), this.createModule(), this.setupProperties());
        this.formSigner = (FormSigner)injector.getInstance(FormSigner.class);
        this.describeRegionsRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DescribeRegions"}).build());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String region : ImmutableSet.of((Object)"ap-northeast-1", (Object)"ap-southeast-1", (Object)"eu-west-1", (Object)"sa-east-1", (Object)"us-east-1", (Object)"us-west-1", (Object[])new String[]{"us-west-2"})) {
            builder.put((Object)this.formSigner.filter(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + region + ".amazonaws.com"})).payload(BaseEC2ExpectTest.payloadFromStringWithContentType((String)"Action=DescribeAvailabilityZones&Version=2010-06-15", (String)"application/x-www-form-urlencoded"))).build()), (Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/availabilityZones-" + region + ".xml", "application/xml"))).build());
        }
        this.describeAvailabilityZonesRequestResponse = builder.build();
    }
}

