/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.options;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.domain.Credentials;
import org.jclouds.ec2.options.BundleInstanceS3StorageOptions;
import org.jclouds.http.options.HttpRequestOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BundleInstanceS3StorageOptionsTest {
    @Test
    public void testAssignability() {
        assert (HttpRequestOptions.class.isAssignableFrom(BundleInstanceS3StorageOptions.class));
        assert (!String.class.isAssignableFrom(BundleInstanceS3StorageOptions.class));
    }

    @Test
    public void testBucketOwnedBy() {
        BundleInstanceS3StorageOptions options = new BundleInstanceS3StorageOptions();
        options.bucketOwnedBy("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Storage.S3.AWSAccessKeyId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testNullBucketOwnedByNotInjected() {
        BundleInstanceS3StorageOptions options = new BundleInstanceS3StorageOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Storage.S3.AWSAccessKeyId"), (Collection)ImmutableList.of());
    }

    @Test
    public void testNullBucketOwnedBy() {
        BundleInstanceS3StorageOptions options = new BundleInstanceS3StorageOptions();
        options.creds = Suppliers.ofInstance((Object)new Credentials("foo", null));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Storage.S3.AWSAccessKeyId"), (Collection)ImmutableList.of((Object)"foo"));
    }

    @Test
    public void testBucketOwnedByStatic() {
        BundleInstanceS3StorageOptions options = BundleInstanceS3StorageOptions.Builder.bucketOwnedBy((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Storage.S3.AWSAccessKeyId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testBucketOwnedByNPE() {
        BundleInstanceS3StorageOptions.Builder.bucketOwnedBy(null);
    }
}

