/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.ec2.options.CreateSnapshotOptions;
import org.jclouds.http.options.HttpRequestOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CreateSnapshotOptionsTest {
    @Test
    public void testAssignability() {
        assert (HttpRequestOptions.class.isAssignableFrom(CreateSnapshotOptions.class));
        assert (!String.class.isAssignableFrom(CreateSnapshotOptions.class));
    }

    @Test
    public void testWithDescription() {
        CreateSnapshotOptions options = new CreateSnapshotOptions();
        options.withDescription("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Description"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullWithDescription() {
        CreateSnapshotOptions options = new CreateSnapshotOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Description"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithDescriptionStatic() {
        CreateSnapshotOptions options = CreateSnapshotOptions.Builder.withDescription((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Description"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithDescriptionNPE() {
        CreateSnapshotOptions.Builder.withDescription(null);
    }
}

