/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.ec2.options.DescribeImagesOptions;
import org.jclouds.http.options.HttpRequestOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DescribeImagesOptionsTest {
    @Test
    public void testAssignability() {
        assert (HttpRequestOptions.class.isAssignableFrom(DescribeImagesOptions.class));
        assert (!String.class.isAssignableFrom(DescribeImagesOptions.class));
    }

    @Test
    public void testExecutableBy() {
        DescribeImagesOptions options = new DescribeImagesOptions();
        options.executableBy("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ExecutableBy"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullExecutableBy() {
        DescribeImagesOptions options = new DescribeImagesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ExecutableBy"), (Collection)ImmutableList.of());
    }

    @Test
    public void testExecutableByStatic() {
        DescribeImagesOptions options = DescribeImagesOptions.Builder.executableBy((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ExecutableBy"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testExecutableByNPE() {
        DescribeImagesOptions.Builder.executableBy(null);
    }

    @Test
    public void testOwners() {
        DescribeImagesOptions options = new DescribeImagesOptions();
        options.ownedBy(new String[]{"test"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Owner.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testMultipleOwners() {
        DescribeImagesOptions options = new DescribeImagesOptions();
        options.ownedBy(new String[]{"test", "trouble"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Owner.1"), (Collection)ImmutableList.of((Object)"test"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Owner.2"), (Collection)ImmutableList.of((Object)"trouble"));
    }

    @Test
    public void testNullOwners() {
        DescribeImagesOptions options = new DescribeImagesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Owner.1"), (Collection)ImmutableList.of());
    }

    @Test
    public void testOwnersStatic() {
        DescribeImagesOptions options = DescribeImagesOptions.Builder.ownedBy((String[])new String[]{"test"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Owner.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    public void testNoOwners() {
        DescribeImagesOptions.Builder.ownedBy((String[])new String[0]);
    }

    @Test
    public void testImageIds() {
        DescribeImagesOptions options = new DescribeImagesOptions();
        options.imageIds(new String[]{"test"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ImageId.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testMultipleImageIds() {
        DescribeImagesOptions options = new DescribeImagesOptions();
        options.imageIds(new String[]{"test", "trouble"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ImageId.1"), (Collection)ImmutableList.of((Object)"test"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ImageId.2"), (Collection)ImmutableList.of((Object)"trouble"));
    }

    @Test
    public void testNullImageIds() {
        DescribeImagesOptions options = new DescribeImagesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ImageId.1"), (Collection)ImmutableList.of());
    }

    @Test
    public void testImageIdsStatic() {
        DescribeImagesOptions options = DescribeImagesOptions.Builder.imageIds((String[])new String[]{"test"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"ImageId.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    public void testNoImageIds() {
        DescribeImagesOptions.Builder.imageIds((String[])new String[0]);
    }
}

