/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.jclouds.ec2.domain.BlockDeviceMapping;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.http.options.HttpRequestOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RunInstancesOptionsTest {
    @Test
    public void testAssignability() {
        assert (HttpRequestOptions.class.isAssignableFrom(RunInstancesOptions.class));
        assert (!String.class.isAssignableFrom(RunInstancesOptions.class));
    }

    @Test
    public void testWithKeyName() {
        RunInstancesOptions options = new RunInstancesOptions();
        options.withKeyName("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"KeyName"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullWithKeyName() {
        RunInstancesOptions options = new RunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"KeyName"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithKeyNameStatic() {
        RunInstancesOptions options = RunInstancesOptions.Builder.withKeyName((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"KeyName"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithKeyNameNPE() {
        RunInstancesOptions.Builder.withKeyName(null);
    }

    @Test
    public void testWithSecurityGroup() {
        RunInstancesOptions options = new RunInstancesOptions();
        options.withSecurityGroup("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"SecurityGroup.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullWithSecurityGroup() {
        RunInstancesOptions options = new RunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"SecurityGroup"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithSecurityGroupStatic() {
        RunInstancesOptions options = RunInstancesOptions.Builder.withSecurityGroup((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"SecurityGroup.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithSecurityGroupNPE() {
        RunInstancesOptions.Builder.withSecurityGroup(null);
    }

    @Test
    public void testNullWithAdditionalInfo() {
        RunInstancesOptions options = new RunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"AdditionalInfo"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithUserData() {
        RunInstancesOptions options = new RunInstancesOptions();
        options.withUserData("test".getBytes());
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"UserData"), (Collection)ImmutableList.of((Object)"dGVzdA=="));
    }

    @Test
    public void testNullWithUserData() {
        RunInstancesOptions options = new RunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"UserData"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithUserDataStatic() {
        RunInstancesOptions options = RunInstancesOptions.Builder.withUserData((byte[])"test".getBytes());
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"UserData"), (Collection)ImmutableList.of((Object)"dGVzdA=="));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithUserDataNPE() {
        RunInstancesOptions.Builder.withUserData(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testWithUserDataEmpty() {
        RunInstancesOptions.Builder.withUserData((byte[])"".getBytes());
    }

    @Test
    public void testWithInstanceType() {
        RunInstancesOptions options = new RunInstancesOptions();
        options.asType("c1.xlarge");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"InstanceType"), (Collection)ImmutableList.of((Object)"c1.xlarge"));
    }

    @Test
    public void testNullWithInstanceType() {
        RunInstancesOptions options = new RunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"InstanceType"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithInstanceTypeStatic() {
        RunInstancesOptions options = RunInstancesOptions.Builder.asType((String)"c1.xlarge");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"InstanceType"), (Collection)ImmutableList.of((Object)"c1.xlarge"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithInstanceTypeNPE() {
        RunInstancesOptions.Builder.asType(null);
    }

    @Test
    public void testWithKernelId() {
        RunInstancesOptions options = new RunInstancesOptions();
        options.withKernelId("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"KernelId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullWithKernelId() {
        RunInstancesOptions options = new RunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"KernelId"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithKernelIdStatic() {
        RunInstancesOptions options = RunInstancesOptions.Builder.withKernelId((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"KernelId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithKernelIdNPE() {
        RunInstancesOptions.Builder.withKernelId(null);
    }

    @Test
    public void testWithRamdisk() {
        RunInstancesOptions options = new RunInstancesOptions();
        options.withRamdisk("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"RamdiskId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullWithRamdisk() {
        RunInstancesOptions options = new RunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"RamdiskId"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithRamdiskStatic() {
        RunInstancesOptions options = RunInstancesOptions.Builder.withRamdisk((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"RamdiskId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithRamdiskNPE() {
        RunInstancesOptions.Builder.withRamdisk(null);
    }

    @Test
    public void testNullWithVirtualName() {
        RunInstancesOptions options = new RunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"BlockDeviceMapping.VirtualName"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithBlockDeviceMapping() {
        BlockDeviceMapping.MapNewVolumeToDevice mapping = new BlockDeviceMapping.MapNewVolumeToDevice("/dev/sda1", Integer.valueOf(120), Boolean.valueOf(true));
        RunInstancesOptions options = new RunInstancesOptions().withBlockDeviceMappings((Set)ImmutableSet.of((Object)mapping));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"BlockDeviceMapping.1.DeviceName"), (Collection)ImmutableList.of((Object)"/dev/sda1"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"BlockDeviceMapping.1.Ebs.VolumeSize"), (Collection)ImmutableList.of((Object)"120"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"BlockDeviceMapping.1.Ebs.DeleteOnTermination"), (Collection)ImmutableList.of((Object)"true"));
    }

    @Test
    public void testNullWithBlockDeviceMapping() {
        RunInstancesOptions options = new RunInstancesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"BlockDeviceMapping"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithBlockDeviceMappingStatic() {
        BlockDeviceMapping.MapNewVolumeToDevice mapping = new BlockDeviceMapping.MapNewVolumeToDevice("/dev/sda1", Integer.valueOf(120), Boolean.valueOf(true));
        RunInstancesOptions options = RunInstancesOptions.Builder.withBlockDeviceMappings((Set)ImmutableSet.of((Object)mapping));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"BlockDeviceMapping.1.DeviceName"), (Collection)ImmutableList.of((Object)"/dev/sda1"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"BlockDeviceMapping.1.Ebs.VolumeSize"), (Collection)ImmutableList.of((Object)"120"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"BlockDeviceMapping.1.Ebs.DeleteOnTermination"), (Collection)ImmutableList.of((Object)"true"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithBlockDeviceMappingNPE() {
        RunInstancesOptions.Builder.withBlockDeviceMappings(null);
    }
}

