/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.services;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilderSpec;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.ec2.EC2ApiMetadata;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.Image;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.domain.Snapshot;
import org.jclouds.ec2.options.CreateSnapshotOptions;
import org.jclouds.ec2.options.DescribeImagesOptions;
import org.jclouds.ec2.options.RegisterImageBackedByEbsOptions;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.ec2.predicates.InstanceStateRunning;
import org.jclouds.ec2.services.AMIClient;
import org.jclouds.rest.RestContext;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public class AMIClientLiveTest
extends BaseComputeServiceContextLiveTest {
    private TemplateBuilderSpec ebsTemplate;
    protected EC2Client ec2Client;
    protected AMIClient client;
    protected Predicate<RunningInstance> runningTester;
    protected Set<String> imagesToDeregister = Sets.newHashSet();
    protected Set<String> snapshotsToDelete = Sets.newHashSet();
    protected String regionId;
    protected String ebsBackedImageId;
    protected String ebsBackedImageName = "jcloudstest1";
    protected String imageId;

    public AMIClientLiveTest() {
        this.provider = "ec2";
    }

    protected Properties setupProperties() {
        Properties overrides = super.setupProperties();
        String ebsSpec = (String)Preconditions.checkNotNull((Object)this.setIfTestSystemPropertyPresent(overrides, this.provider + ".ebs-template"), (Object)(this.provider + ".ebs-template"));
        this.ebsTemplate = TemplateBuilderSpec.parse((String)ebsSpec);
        return overrides;
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.ec2Client = (EC2Client)((RestContext)((ComputeServiceContext)this.view).unwrap(EC2ApiMetadata.CONTEXT_TOKEN)).getApi();
        this.runningTester = Predicates2.retry((Predicate)new InstanceStateRunning(this.ec2Client), (long)600L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        this.client = this.ec2Client.getAMIServices();
        if (this.ebsTemplate != null) {
            Template template = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().from(this.ebsTemplate).build();
            this.regionId = template.getLocation().getId();
            this.imageId = template.getImage().getProviderId();
            for (Image image : this.client.describeImagesInRegion(this.regionId, new DescribeImagesOptions[0])) {
                if (!this.ebsBackedImageName.equals(image.getName())) continue;
                this.client.deregisterImageInRegion(this.regionId, image.getId());
            }
        }
    }

    public void testDescribeImageNotExists() {
        Assert.assertEquals((int)this.client.describeImagesInRegion(null, new DescribeImagesOptions[]{DescribeImagesOptions.Builder.imageIds((String[])new String[]{"ami-cdf819a3"})}).size(), (int)0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDescribeImageBadId() {
        this.client.describeImagesInRegion(null, new DescribeImagesOptions[]{DescribeImagesOptions.Builder.imageIds((String[])new String[]{"asdaasdsa"})});
    }

    public void testDescribeImages() {
        for (String region : this.ec2Client.getConfiguredRegions()) {
            Set allResults = this.client.describeImagesInRegion(region, new DescribeImagesOptions[0]);
            Assert.assertNotNull((Object)allResults);
            assert (allResults.size() >= 2) : allResults.size();
            Iterator iterator = allResults.iterator();
            String id1 = ((Image)iterator.next()).getId();
            String id2 = ((Image)iterator.next()).getId();
            Set twoResults = this.client.describeImagesInRegion(region, new DescribeImagesOptions[]{DescribeImagesOptions.Builder.imageIds((String[])new String[]{id1, id2})});
            Assert.assertNotNull((Object)twoResults);
            Assert.assertEquals((int)twoResults.size(), (int)2);
            iterator = twoResults.iterator();
            Assert.assertEquals((String)((Image)iterator.next()).getId(), (String)id1);
            Assert.assertEquals((String)((Image)iterator.next()).getId(), (String)id2);
        }
    }

    @Test
    public void testCreateAndListEBSBackedImage() throws Exception {
        Snapshot snapshot = this.createSnapshot();
        int sizeBefore = this.client.describeImagesInRegion(this.regionId, new DescribeImagesOptions[0]).size();
        this.ebsBackedImageId = this.client.registerUnixImageBackedByEbsInRegion(this.regionId, this.ebsBackedImageName, snapshot.getId(), new RegisterImageBackedByEbsOptions[]{RegisterImageBackedByEbsOptions.Builder.addNewBlockDevice((String)"/dev/sda2", (String)"myvirtual", (int)1).withDescription("adrian")});
        this.imagesToDeregister.add(this.ebsBackedImageId);
        Image ebsBackedImage = (Image)Iterables.getOnlyElement((Iterable)this.client.describeImagesInRegion(this.regionId, new DescribeImagesOptions[]{DescribeImagesOptions.Builder.imageIds((String[])new String[]{this.ebsBackedImageId})}));
        Assert.assertEquals((String)ebsBackedImage.getName(), (String)this.ebsBackedImageName);
        Assert.assertEquals((Object)ebsBackedImage.getImageType(), (Object)Image.ImageType.MACHINE);
        Assert.assertEquals((Object)ebsBackedImage.getRootDeviceType(), (Object)RootDeviceType.EBS);
        Assert.assertEquals((String)ebsBackedImage.getRootDeviceName(), (String)"/dev/sda1");
        Assert.assertEquals((String)ebsBackedImage.getDescription(), (String)"adrian");
        Assert.assertEquals(ebsBackedImage.getEbsBlockDevices().entrySet(), (Set)ImmutableMap.of((Object)"/dev/sda1", (Object)new Image.EbsBlockDevice(snapshot.getId(), (long)snapshot.getVolumeSize(), true), (Object)"/dev/sda2", (Object)new Image.EbsBlockDevice(null, 1L, false)).entrySet());
        int after = this.client.describeImagesInRegion(this.regionId, new DescribeImagesOptions[0]).size();
        Assert.assertEquals((int)after, (int)(sizeBefore + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Snapshot createSnapshot() throws RunNodesException {
        Snapshot snapshot;
        block3: {
            String instanceId = null;
            try {
                RunningInstance instance = (RunningInstance)Iterables.getOnlyElement((Iterable)Iterables.concat((Iterable[])new Iterable[]{this.ec2Client.getInstanceServices().runInstancesInRegion(this.regionId, null, this.imageId, 1, 1, new RunInstancesOptions[0])}));
                instanceId = instance.getId();
                Assert.assertTrue((boolean)this.runningTester.apply((Object)instance), (String)(instanceId + "didn't achieve the state running!"));
                instance = (RunningInstance)Iterables.getOnlyElement((Iterable)Iterables.concat((Iterable)this.ec2Client.getInstanceServices().describeInstancesInRegion(this.regionId, new String[]{instanceId})));
                BlockDevice device = (BlockDevice)instance.getEbsBlockDevices().get("/dev/sda1");
                Assert.assertNotNull((Object)device, (String)("device: /dev/sda1 not present on: " + instance));
                Snapshot snapshot2 = this.ec2Client.getElasticBlockStoreServices().createSnapshotInRegion(this.regionId, device.getVolumeId(), new CreateSnapshotOptions[0]);
                this.snapshotsToDelete.add(snapshot2.getId());
                snapshot = snapshot2;
                if (instanceId == null) break block3;
            }
            catch (Throwable throwable) {
                if (instanceId != null) {
                    this.ec2Client.getInstanceServices().terminateInstancesInRegion(this.regionId, new String[]{instanceId});
                }
                throw throwable;
            }
            this.ec2Client.getInstanceServices().terminateInstancesInRegion(this.regionId, new String[]{instanceId});
        }
        return snapshot;
    }

    @Test(dependsOnMethods={"testCreateAndListEBSBackedImage"})
    public void testGetLaunchPermissionForImage() {
        this.client.getLaunchPermissionForImageInRegion(this.regionId, this.ebsBackedImageId);
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDownContext() {
        for (String imageId : this.imagesToDeregister) {
            this.client.deregisterImageInRegion(this.regionId, imageId);
        }
        for (String snapshotId : this.snapshotsToDelete) {
            this.ec2Client.getElasticBlockStoreServices().deleteSnapshotInRegion(this.regionId, snapshotId);
        }
        super.tearDownContext();
    }
}

