/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.services;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.ec2.options.DescribeAvailabilityZonesOptions;
import org.jclouds.ec2.options.DescribeRegionsOptions;
import org.jclouds.ec2.services.AvailabilityZoneAndRegionAsyncClient;
import org.jclouds.ec2.services.BaseEC2AsyncClientTest;
import org.jclouds.ec2.xml.DescribeAvailabilityZonesResponseHandler;
import org.jclouds.ec2.xml.DescribeRegionsResponseHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AvailabilityZoneAndRegionAsyncClientTest")
public class AvailabilityZoneAndRegionAsyncClientTest
extends BaseEC2AsyncClientTest<AvailabilityZoneAndRegionAsyncClient> {
    public void testDescribeAvailabilityZones() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AvailabilityZoneAndRegionAsyncClient.class, (String)"describeAvailabilityZonesInRegion", (Class[])new Class[]{String.class, DescribeAvailabilityZonesOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"us-west-1"));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-west-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-west-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=DescribeAvailabilityZones", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, DescribeAvailabilityZonesResponseHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDescribeAvailabilityZonesOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AvailabilityZoneAndRegionAsyncClient.class, (String)"describeAvailabilityZonesInRegion", (Class[])new Class[]{String.class, DescribeAvailabilityZonesOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"us-east-1", (Object)DescribeAvailabilityZonesOptions.Builder.availabilityZones((String[])new String[]{"us-east-1a", "us-east-1b"})));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=DescribeAvailabilityZones&ZoneName.1=us-east-1a&ZoneName.2=us-east-1b", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, DescribeAvailabilityZonesResponseHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDescribeRegions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AvailabilityZoneAndRegionAsyncClient.class, (String)"describeRegions", (Class[])new Class[]{DescribeRegionsOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=DescribeRegions", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, DescribeRegionsResponseHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testDescribeRegionsOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AvailabilityZoneAndRegionAsyncClient.class, (String)"describeRegions", (Class[])new Class[]{DescribeRegionsOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)DescribeRegionsOptions.Builder.regions((String[])new String[]{"us-east-1", "us-west-1"})));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=DescribeRegions&RegionName.1=us-east-1&RegionName.2=us-west-1", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, DescribeRegionsResponseHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }
}

