/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.services;

import com.google.common.collect.Sets;
import java.util.TreeSet;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.ec2.EC2ApiMetadata;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.domain.PublicIpInstanceIdPair;
import org.jclouds.ec2.services.ElasticIPAddressClient;
import org.jclouds.rest.RestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="ElasticIPAddressClientLiveTest")
public class ElasticIPAddressClientLiveTest
extends BaseComputeServiceContextLiveTest {
    private EC2Client ec2Client;
    private ElasticIPAddressClient client;

    public ElasticIPAddressClientLiveTest() {
        this.provider = "ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.ec2Client = (EC2Client)((RestContext)((ComputeServiceContext)this.view).unwrap(EC2ApiMetadata.CONTEXT_TOKEN)).getApi();
        this.client = this.ec2Client.getElasticIPAddressServices();
    }

    @Test
    void testDescribeAddresses() {
        for (String region : this.ec2Client.getConfiguredRegions()) {
            TreeSet allResults = Sets.newTreeSet((Iterable)this.client.describeAddressesInRegion(region, new String[0]));
            Assert.assertNotNull((Object)allResults);
            if (allResults.size() < 1) continue;
            PublicIpInstanceIdPair pair = (PublicIpInstanceIdPair)allResults.last();
            TreeSet result = Sets.newTreeSet((Iterable)this.client.describeAddressesInRegion(region, new String[]{pair.getPublicIp()}));
            Assert.assertNotNull((Object)result);
            PublicIpInstanceIdPair compare = (PublicIpInstanceIdPair)result.last();
            Assert.assertEquals((Object)compare, (Object)pair);
        }
    }
}

