/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.collect.Sets;
import java.io.InputStream;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.xml.BaseEC2HandlerTest;
import org.jclouds.ec2.xml.CreateVolumeResponseHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CreateVolumeResponseHandlerTest")
public class CreateVolumeResponseHandlerTest
extends BaseEC2HandlerTest {
    public void testApplyInputStream() {
        DateService dateService = (DateService)this.injector.getInstance(DateService.class);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/created_volume.xml");
        Volume expected = new Volume("us-east-1", "vol-2a21e543", 1, null, "us-east-1a", Volume.Status.CREATING, dateService.iso8601DateParse("2009-12-28T05:42:53.000Z"), (Iterable)Sets.newLinkedHashSet());
        CreateVolumeResponseHandler handler = (CreateVolumeResponseHandler)this.injector.getInstance(CreateVolumeResponseHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        Volume result = (Volume)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((Object)result, (Object)expected);
    }

    private void addDefaultRegionToHandler(ParseSax.HandlerWithResult<?> handler) {
        handler.setContext((HttpRequest)this.request);
    }
}

