/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Set;
import org.jclouds.ec2.domain.PublicIpInstanceIdPair;
import org.jclouds.ec2.xml.BaseEC2HandlerTest;
import org.jclouds.ec2.xml.DescribeAddressesResponseHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DescribeAddressesResponseHandlerTest")
public class DescribeAddressesResponseHandlerTest
extends BaseEC2HandlerTest {
    public void testApplyInputStream() throws UnknownHostException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/describe_addresses.xml");
        DescribeAddressesResponseHandler handler = (DescribeAddressesResponseHandler)this.injector.getInstance(DescribeAddressesResponseHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        Set result = (Set)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((Collection)result, (Collection)ImmutableList.of((Object)new PublicIpInstanceIdPair(this.defaultRegion, "67.202.55.255", "i-f15ebb98"), (Object)new PublicIpInstanceIdPair(this.defaultRegion, "67.202.55.233", null)));
    }

    private void addDefaultRegionToHandler(ParseSax.HandlerWithResult<?> handler) {
        handler.setContext((HttpRequest)this.request);
    }
}

