/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.io.InputStream;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.ec2.domain.AvailabilityZoneInfo;
import org.jclouds.ec2.xml.DescribeAvailabilityZonesResponseHandler;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.location.Region;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DescribeAvailabilityZonesResponseHandlerTest")
public class DescribeAvailabilityZonesResponseHandlerTest
extends BaseHandlerTest {
    @BeforeTest
    protected void setUpInjector() {
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(){

            @Singleton
            @Provides
            @Region
            Supplier<String> provideDefaultRegion() {
                return Suppliers.ofInstance((Object)"SHOULDNTSEETHISASXMLHASREGIONDATA");
            }
        }});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        assert (this.factory != null);
    }

    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/availabilityZones.xml");
        ImmutableSet expected = ImmutableSet.of((Object)new AvailabilityZoneInfo("us-east-1a", "available", "us-east-1", (Iterable)ImmutableSet.of()), (Object)new AvailabilityZoneInfo("us-east-1b", "available", "us-east-1", (Iterable)ImmutableSet.of()), (Object)new AvailabilityZoneInfo("us-east-1c", "available", "us-east-1", (Iterable)ImmutableSet.of((Object)"our service is awesome")), (Object)new AvailabilityZoneInfo("us-east-1d", "downlikeaclown", "us-east-1", (Iterable)ImmutableSet.of()));
        Set result = (Set)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(DescribeAvailabilityZonesResponseHandler.class)).parse(is);
        Assert.assertEquals((Set)result, (Set)expected);
    }
}

