/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.collect.Iterables;
import java.io.InputStream;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.BundleTask;
import org.jclouds.ec2.xml.BaseEC2HandlerTest;
import org.jclouds.ec2.xml.DescribeBundleTasksResponseHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DescribeBundleTasksResponseHandlerTest")
public class DescribeBundleTasksResponseHandlerTest
extends BaseEC2HandlerTest {
    public void testApplyInputStream() {
        DateService dateService = (DateService)this.injector.getInstance(DateService.class);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/describe_bundle_tasks.xml");
        BundleTask expected = new BundleTask(this.defaultRegion, "bun-c1a540a8", null, "i-12345678", 20, dateService.iso8601DateParse("2008-10-07T11:41:50.000Z"), "canceling", "my-bucket", "winami", dateService.iso8601DateParse("2008-10-07T11:51:50.000Z"));
        DescribeBundleTasksResponseHandler handler = (DescribeBundleTasksResponseHandler)this.injector.getInstance(DescribeBundleTasksResponseHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        BundleTask result = (BundleTask)Iterables.getOnlyElement((Iterable)((Iterable)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is)));
        Assert.assertEquals((Object)result, (Object)expected);
    }

    private void addDefaultRegionToHandler(ParseSax.HandlerWithResult<?> handler) {
        handler.setContext((HttpRequest)this.request);
    }
}

