/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.jclouds.ec2.xml.DescribeRegionsResponseHandler;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.location.Provider;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DescribeRegionsResponseHandlerTest")
public class DescribeRegionsResponseHandlerTest
extends BaseHandlerTest {
    @BeforeTest
    protected void setUpInjector() {
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(), new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Supplier<URI>>(){}).annotatedWith(Provider.class).toInstance((Object)Suppliers.ofInstance((Object)URI.create("https://booya")));
            }
        }});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        assert (this.factory != null);
    }

    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/regionEndpoints.xml");
        ImmutableMap expected = ImmutableMap.of((Object)"eu-west-1", (Object)URI.create("https://ec2.eu-west-1.amazonaws.com"), (Object)"us-east-1", (Object)URI.create("https://ec2.us-east-1.amazonaws.com"), (Object)"us-west-1", (Object)URI.create("https://ec2.us-west-1.amazonaws.com"));
        Map result = (Map)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(DescribeRegionsResponseHandler.class)).parse(is);
        Assert.assertEquals((Map)result, (Map)expected);
    }

    public void testEuc() {
        InputStream is = Strings2.toInputStream((String)"<DescribeRegionsResponse xmlns=\"http://ec2.amazonaws.com/doc/2010-06-15/\"><requestId>6a3b36f9-9ff4-47cf-87e3-285b08fbe5e5</requestId><regionInfo><item><regionName>Eucalyptus</regionName><regionEndpoint>http://173.205.188.130:8773/services/Eucalyptus</regionEndpoint></item><item><regionName>Walrus</regionName><regionEndpoint>http://173.205.188.130:8773/services/Walrus</regionEndpoint></item></regionInfo></DescribeRegionsResponse>");
        ImmutableMap expected = ImmutableMap.of((Object)"Eucalyptus", (Object)URI.create("http://173.205.188.130:8773/services/Eucalyptus"));
        Map result = (Map)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(DescribeRegionsResponseHandler.class)).parse(is);
        Assert.assertEquals((Map)result, (Map)expected);
    }

    public void testEuc2() {
        InputStream is = Strings2.toInputStream((String)"<?xml version=\"1.0\" ?><DescribeRegionsResponse xmlns=\"http://ec2.amazonaws.com/doc/2009-11-30/\"><requestId>1LAQRTCLTLPS6CEIC627</requestId><regionInfo><item><regionUrl>http://10.255.255.1:8773/services/Cloud</regionUrl><regionName>nova</regionName></item></regionInfo></DescribeRegionsResponse>");
        ImmutableMap expected = ImmutableMap.of((Object)"nova", (Object)URI.create("http://10.255.255.1:8773/services/Cloud"));
        Map result = (Map)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(DescribeRegionsResponseHandler.class)).parse(is);
        Assert.assertEquals((Map)result, (Map)expected);
    }

    public void testUnsupportedAdditionalRegionDoesntBreak() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/regionEndpoints-additional.xml");
        ImmutableMap expected = ImmutableMap.of((Object)"jp-west-1", (Object)URI.create("https://ec2.jp-west-1.amazonaws.com"), (Object)"eu-west-1", (Object)URI.create("https://ec2.eu-west-1.amazonaws.com"), (Object)"us-east-1", (Object)URI.create("https://ec2.us-east-1.amazonaws.com"), (Object)"us-west-1", (Object)URI.create("https://ec2.us-west-1.amazonaws.com"));
        Map result = (Map)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(DescribeRegionsResponseHandler.class)).parse(is);
        Assert.assertEquals((Map)result, (Map)expected);
    }
}

