/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.InputStream;
import java.util.Set;
import org.jclouds.ec2.domain.IpPermission;
import org.jclouds.ec2.domain.IpProtocol;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.ec2.xml.BaseEC2HandlerTest;
import org.jclouds.ec2.xml.DescribeSecurityGroupsResponseHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DescribeSecurityGroupsResponseHandlerTest")
public class DescribeSecurityGroupsResponseHandlerTest
extends BaseEC2HandlerTest {
    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/describe_securitygroups.xml");
        ImmutableSet expected = ImmutableSet.of((Object)new SecurityGroup(this.defaultRegion, null, "WebServers", "UYY3TLBUXIEON5NQVUUX6OMPWBZIQNFM", "Web Servers", (Iterable)ImmutableSet.of((Object)new IpPermission(IpProtocol.TCP, 80, 80, (Multimap)ImmutableMultimap.of(), (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of((Object)"0.0.0.0/0")))), (Object)new SecurityGroup(this.defaultRegion, null, "RangedPortsBySource", "UYY3TLBUXIEON5NQVUUX6OMPWBZIQNFM", "Group A", (Iterable)ImmutableSet.of((Object)new IpPermission(IpProtocol.TCP, 6000, 7000, (Multimap)ImmutableMultimap.of(), (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of()))));
        DescribeSecurityGroupsResponseHandler handler = (DescribeSecurityGroupsResponseHandler)this.injector.getInstance(DescribeSecurityGroupsResponseHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        Set result = (Set)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toString(), (String)expected.toString());
    }

    public void testApplyInputStreamWithEmptyFields() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/describe_securitygroups_empty.xml");
        LinkedHashMultimap userIdGroupPairs = LinkedHashMultimap.create();
        userIdGroupPairs.put((Object)"UYY3TLBUXIEON5NQVUUX6OMPWBZIQNFM", (Object)"jclouds#cluster#world");
        ImmutableSet expected = ImmutableSet.of((Object)new SecurityGroup(this.defaultRegion, null, "jclouds#cluster#world", "UYY3TLBUXIEON5NQVUUX6OMPWBZIQNFM", "Cluster", (Iterable)ImmutableSet.of((Object)new IpPermission(IpProtocol.TCP, 22, 22, (Multimap)ImmutableMultimap.of(), (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of((Object)"0.0.0.0/0")), (Object)new IpPermission(IpProtocol.ALL, -1, -1, (Multimap)userIdGroupPairs, (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of()))));
        DescribeSecurityGroupsResponseHandler handler = (DescribeSecurityGroupsResponseHandler)this.injector.getInstance(DescribeSecurityGroupsResponseHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        Set result = (Set)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toString(), (String)expected.toString());
    }

    private void addDefaultRegionToHandler(ParseSax.HandlerWithResult<?> handler) {
        handler.setContext((HttpRequest)this.request);
    }
}

