/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.Set;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.InstanceStateChange;
import org.jclouds.ec2.xml.BaseEC2HandlerTest;
import org.jclouds.ec2.xml.InstanceStateChangeHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="InstanceStateChangeHandlerTest")
public class InstanceStateChangeHandlerTest
extends BaseEC2HandlerTest {
    private DateService dateService;

    @Override
    @BeforeTest
    protected void setUpInjector() {
        super.setUpInjector();
        this.dateService = (DateService)this.injector.getInstance(DateService.class);
        assert (this.dateService != null);
    }

    public void testTerminate() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/terminate_instances.xml");
        ImmutableSet expected = ImmutableSet.of((Object)new InstanceStateChange(this.defaultRegion, "i-3ea74257", InstanceState.SHUTTING_DOWN, InstanceState.RUNNING));
        InstanceStateChangeHandler handler = (InstanceStateChangeHandler)this.injector.getInstance(InstanceStateChangeHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        Set result = (Set)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((Set)result, (Set)expected);
    }

    public void testStart() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/start_instances.xml");
        ImmutableSet expected = ImmutableSet.of((Object)new InstanceStateChange(this.defaultRegion, "i-10a64379", InstanceState.PENDING, InstanceState.STOPPED));
        InstanceStateChangeHandler handler = (InstanceStateChangeHandler)this.injector.getInstance(InstanceStateChangeHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        Set result = (Set)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((Set)result, (Set)expected);
    }

    public void testStop() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/stop_instances.xml");
        ImmutableSet expected = ImmutableSet.of((Object)new InstanceStateChange(this.defaultRegion, "i-10a64379", InstanceState.STOPPING, InstanceState.RUNNING));
        InstanceStateChangeHandler handler = (InstanceStateChangeHandler)this.injector.getInstance(InstanceStateChangeHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        Set result = (Set)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((Set)result, (Set)expected);
    }

    private void addDefaultRegionToHandler(ParseSax.HandlerWithResult<?> handler) {
        handler.setContext((HttpRequest)this.request);
    }
}

