/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;

@Singleton
public class EC2ListNodesStrategy
implements ListNodesStrategy {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected static Long maxTime;
    protected final EC2Client client;
    protected final Supplier<Set<String>> regions;
    protected final Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata;
    protected final ListeningExecutorService userExecutor;

    @Inject
    protected EC2ListNodesStrategy(EC2Client client, @Region Supplier<Set<String>> regions, Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.client = (EC2Client)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.regions = (Supplier)Preconditions.checkNotNull(regions, (Object)"regions");
        this.runningInstanceToNodeMetadata = (Function)Preconditions.checkNotNull(runningInstanceToNodeMetadata, (Object)"runningInstanceToNodeMetadata");
        this.userExecutor = (ListeningExecutorService)Preconditions.checkNotNull((Object)userExecutor, (Object)"userExecutor");
    }

    public Set<? extends ComputeMetadata> listNodes() {
        return this.listDetailsOnNodesMatching(NodePredicates.all());
    }

    public Set<? extends NodeMetadata> listNodesByIds(Iterable<String> ids) {
        ImmutableListMultimap idsByHandles = Multimaps.index(ids, this.splitHandle(1));
        Multimap idsByRegions = Multimaps.transformValues((Multimap)idsByHandles, this.splitHandle(0));
        Multimap idsByConfiguredRegions = Multimaps.filterKeys((Multimap)idsByRegions, (Predicate)Predicates.in((Collection)((Collection)this.regions.get())));
        if (idsByConfiguredRegions.isEmpty()) {
            return ImmutableSet.of();
        }
        Iterable<? extends RunningInstance> instances = this.pollRunningInstancesByRegionsAndIds((Multimap<String, String>)idsByConfiguredRegions);
        Iterable nodes = Iterables.transform((Iterable)Iterables.filter(instances, (Predicate)Predicates.notNull()), this.runningInstanceToNodeMetadata);
        return ImmutableSet.copyOf((Iterable)nodes);
    }

    public Set<? extends NodeMetadata> listDetailsOnNodesMatching(Predicate<ComputeMetadata> filter) {
        Iterable<? extends RunningInstance> instances = this.pollRunningInstances();
        Iterable nodes = Iterables.filter((Iterable)Iterables.transform((Iterable)Iterables.filter(instances, (Predicate)Predicates.notNull()), this.runningInstanceToNodeMetadata), (Predicate)Predicates.and((Predicate)Predicates.notNull(), filter));
        return ImmutableSet.copyOf((Iterable)nodes);
    }

    protected Iterable<? extends RunningInstance> pollRunningInstances() {
        Iterable reservations = Iterables.transform((Iterable)((Iterable)this.regions.get()), this.allInstancesInRegion());
        return Iterables.concat((Iterable)Iterables.concat((Iterable)reservations));
    }

    protected Iterable<? extends RunningInstance> pollRunningInstancesByRegionsAndIds(Multimap<String, String> idsByRegions) {
        Iterable reservations = Iterables.transform((Iterable)idsByRegions.keySet(), this.instancesByIdInRegion(idsByRegions));
        return Iterables.concat((Iterable)Iterables.concat((Iterable)reservations));
    }

    protected Function<String, String> splitHandle(final int pos) {
        return new Function<String, String>(){

            public String apply(String handle) {
                return AWSUtils.parseHandle((String)handle)[pos];
            }
        };
    }

    protected Function<String, Set<? extends Reservation<? extends RunningInstance>>> allInstancesInRegion() {
        return new Function<String, Set<? extends Reservation<? extends RunningInstance>>>(){

            public Set<? extends Reservation<? extends RunningInstance>> apply(String from) {
                return EC2ListNodesStrategy.this.client.getInstanceServices().describeInstancesInRegion(from, new String[0]);
            }
        };
    }

    protected Function<String, Set<? extends Reservation<? extends RunningInstance>>> instancesByIdInRegion(final Multimap<String, String> idsByRegions) {
        return new Function<String, Set<? extends Reservation<? extends RunningInstance>>>(){

            public Set<? extends Reservation<? extends RunningInstance>> apply(String from) {
                return EC2ListNodesStrategy.this.client.getInstanceServices().describeInstancesInRegion(from, (String[])Iterables.toArray((Iterable)idsByRegions.get((Object)from), String.class));
            }
        };
    }
}

