/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.jclouds.ec2.domain.Hypervisor;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.VirtualizationType;
import org.jclouds.javax.annotation.Nullable;

public class Image
implements Comparable<Image> {
    private final String region;
    private final Architecture architecture;
    @Nullable
    private final String name;
    @Nullable
    private final String description;
    private final String imageId;
    private final String imageLocation;
    private final String imageOwnerId;
    private final ImageState imageState;
    private final String rawState;
    private final ImageType imageType;
    private final boolean isPublic;
    @Nullable
    private final String kernelId;
    @Nullable
    private final String platform;
    private final Set<String> productCodes = Sets.newHashSet();
    @Nullable
    private final String ramdiskId;
    private final RootDeviceType rootDeviceType;
    @Nullable
    private final String rootDeviceName;
    private final Map<String, EbsBlockDevice> ebsBlockDevices = Maps.newHashMap();
    private final VirtualizationType virtualizationType;
    private final Hypervisor hypervisor;

    public VirtualizationType getVirtualizationType() {
        return this.virtualizationType;
    }

    public Hypervisor getHypervisor() {
        return this.hypervisor;
    }

    public Image(String region, Architecture architecture, @Nullable String name, @Nullable String description, String imageId, String imageLocation, String imageOwnerId, ImageState imageState, String rawState, ImageType imageType, boolean isPublic, Iterable<String> productCodes, @Nullable String kernelId, @Nullable String platform, @Nullable String ramdiskId, RootDeviceType rootDeviceType, @Nullable String rootDeviceName, Map<String, EbsBlockDevice> ebsBlockDevices, VirtualizationType virtualizationType, Hypervisor hypervisor) {
        this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"region");
        this.architecture = architecture;
        this.imageId = (String)Preconditions.checkNotNull((Object)imageId, (Object)"imageId");
        this.name = name;
        this.description = description;
        this.rootDeviceName = rootDeviceName;
        this.imageLocation = (String)Preconditions.checkNotNull((Object)imageLocation, (Object)"imageLocation");
        this.imageOwnerId = (String)Preconditions.checkNotNull((Object)imageOwnerId, (Object)"imageOwnerId");
        this.imageState = (ImageState)((Object)Preconditions.checkNotNull((Object)((Object)imageState), (Object)"imageState"));
        this.rawState = (String)Preconditions.checkNotNull((Object)rawState, (Object)"rawState");
        this.imageType = (ImageType)((Object)Preconditions.checkNotNull((Object)((Object)imageType), (Object)"imageType"));
        this.isPublic = isPublic;
        this.kernelId = kernelId;
        this.platform = platform;
        Iterables.addAll(this.productCodes, (Iterable)((Iterable)Preconditions.checkNotNull(productCodes, (Object)"productCodes")));
        this.ramdiskId = ramdiskId;
        this.rootDeviceType = (RootDeviceType)((Object)Preconditions.checkNotNull((Object)((Object)rootDeviceType), (Object)"rootDeviceType"));
        this.ebsBlockDevices.putAll((Map)Preconditions.checkNotNull(ebsBlockDevices, (Object)"ebsBlockDevices"));
        this.virtualizationType = (VirtualizationType)((Object)Preconditions.checkNotNull((Object)((Object)virtualizationType), (Object)"virtualizationType"));
        this.hypervisor = (Hypervisor)((Object)Preconditions.checkNotNull((Object)((Object)hypervisor), (Object)"hypervisor"));
    }

    @Deprecated
    public String getRegion() {
        return this.region;
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public String getId() {
        return this.imageId;
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public String getImageOwnerId() {
        return this.imageOwnerId;
    }

    public ImageState getImageState() {
        return this.imageState;
    }

    public String getRawState() {
        return this.rawState;
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Set<String> getProductCodes() {
        return this.productCodes;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    @Override
    public int compareTo(Image o) {
        return this == o ? 0 : this.getId().compareTo(o.getId());
    }

    public RootDeviceType getRootDeviceType() {
        return this.rootDeviceType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRootDeviceName() {
        return this.rootDeviceName;
    }

    public Map<String, EbsBlockDevice> getEbsBlockDevices() {
        return this.ebsBlockDevices;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.architecture == null ? 0 : this.architecture.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.ebsBlockDevices == null ? 0 : this.ebsBlockDevices.hashCode());
        result = 31 * result + (this.imageId == null ? 0 : this.imageId.hashCode());
        result = 31 * result + (this.imageLocation == null ? 0 : this.imageLocation.hashCode());
        result = 31 * result + (this.imageOwnerId == null ? 0 : this.imageOwnerId.hashCode());
        result = 31 * result + (this.imageType == null ? 0 : this.imageType.hashCode());
        result = 31 * result + (this.isPublic ? 1231 : 1237);
        result = 31 * result + (this.kernelId == null ? 0 : this.kernelId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.platform == null ? 0 : this.platform.hashCode());
        result = 31 * result + (this.productCodes == null ? 0 : this.productCodes.hashCode());
        result = 31 * result + (this.ramdiskId == null ? 0 : this.ramdiskId.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.rootDeviceName == null ? 0 : this.rootDeviceName.hashCode());
        result = 31 * result + (this.rootDeviceType == null ? 0 : this.rootDeviceType.hashCode());
        result = 31 * result + (this.virtualizationType == null ? 0 : this.virtualizationType.hashCode());
        result = 31 * result + (this.hypervisor == null ? 0 : this.hypervisor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Image other = (Image)obj;
        if (this.architecture == null ? other.architecture != null : !this.architecture.equals((Object)other.architecture)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.ebsBlockDevices == null ? other.ebsBlockDevices != null : !this.ebsBlockDevices.equals(other.ebsBlockDevices)) {
            return false;
        }
        if (this.imageId == null ? other.imageId != null : !this.imageId.equals(other.imageId)) {
            return false;
        }
        if (this.imageLocation == null ? other.imageLocation != null : !this.imageLocation.equals(other.imageLocation)) {
            return false;
        }
        if (this.imageOwnerId == null ? other.imageOwnerId != null : !this.imageOwnerId.equals(other.imageOwnerId)) {
            return false;
        }
        if (this.imageType == null ? other.imageType != null : !this.imageType.equals((Object)other.imageType)) {
            return false;
        }
        if (this.isPublic != other.isPublic) {
            return false;
        }
        if (this.kernelId == null ? other.kernelId != null : !this.kernelId.equals(other.kernelId)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.platform == null ? other.platform != null : !this.platform.equals(other.platform)) {
            return false;
        }
        if (this.productCodes == null ? other.productCodes != null : !this.productCodes.equals(other.productCodes)) {
            return false;
        }
        if (this.ramdiskId == null ? other.ramdiskId != null : !this.ramdiskId.equals(other.ramdiskId)) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        if (this.rootDeviceName == null ? other.rootDeviceName != null : !this.rootDeviceName.equals(other.rootDeviceName)) {
            return false;
        }
        if (this.rootDeviceType == null ? other.rootDeviceType != null : !this.rootDeviceType.equals((Object)other.rootDeviceType)) {
            return false;
        }
        if (this.virtualizationType == null ? other.virtualizationType != null : !this.virtualizationType.equals((Object)other.virtualizationType)) {
            return false;
        }
        return !(this.hypervisor == null ? other.hypervisor != null : !this.hypervisor.equals((Object)other.hypervisor));
    }

    public String toString() {
        return "Image [architecture=" + (Object)((Object)this.architecture) + ", description=" + this.description + ", ebsBlockDevices=" + this.ebsBlockDevices + ", imageId=" + this.imageId + ", imageLocation=" + this.imageLocation + ", imageOwnerId=" + this.imageOwnerId + ", imageState=" + this.rawState + ", imageType=" + (Object)((Object)this.imageType) + ", isPublic=" + this.isPublic + ", kernelId=" + this.kernelId + ", name=" + this.name + ", platform=" + this.platform + ", productCodes=" + this.productCodes + ", ramdiskId=" + this.ramdiskId + ", region=" + this.region + ", rootDeviceName=" + this.rootDeviceName + ", rootDeviceType=" + (Object)((Object)this.rootDeviceType) + ", virtualizationType=" + (Object)((Object)this.virtualizationType) + ", hypervisor=" + (Object)((Object)this.hypervisor) + "]";
    }

    public static class EbsBlockDevice {
        @Nullable
        private final String snapshotId;
        private final long volumeSize;
        private final boolean deleteOnTermination;

        public EbsBlockDevice(@Nullable String snapshotId, long volumeSize, boolean deleteOnTermination) {
            this.snapshotId = snapshotId;
            this.volumeSize = volumeSize;
            this.deleteOnTermination = deleteOnTermination;
        }

        public String getSnapshotId() {
            return this.snapshotId;
        }

        public long getVolumeSize() {
            return this.volumeSize;
        }

        public boolean isDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.deleteOnTermination ? 1231 : 1237);
            result = 31 * result + (this.snapshotId == null ? 0 : this.snapshotId.hashCode());
            result = 31 * result + (int)(this.volumeSize ^ this.volumeSize >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EbsBlockDevice other = (EbsBlockDevice)obj;
            if (this.deleteOnTermination != other.deleteOnTermination) {
                return false;
            }
            if (this.snapshotId == null ? other.snapshotId != null : !this.snapshotId.equals(other.snapshotId)) {
                return false;
            }
            return this.volumeSize == other.volumeSize;
        }

        public String toString() {
            return "EbsBlockDevice [deleteOnTermination=" + this.deleteOnTermination + ", snapshotId=" + this.snapshotId + ", volumeSize=" + this.volumeSize + "]";
        }
    }

    public static enum ImageType {
        MACHINE,
        KERNEL,
        RAMDISK,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public static ImageType fromValue(String v) {
            try {
                return ImageType.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Architecture {
        I386,
        X86_64,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public static Architecture fromValue(String v) {
            try {
                return Architecture.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum ImageState {
        AVAILABLE,
        DEREGISTERED,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public static ImageState fromValue(String v) {
            try {
                return ImageState.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

