/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class Subnet {
    private final String subnetId;
    private final State subnetState;
    private final String vpcId;
    private final String cidrBlock;
    private final int availableIpAddressCount;
    private final String availabilityZone;
    private final Map<String, String> tags;

    private Subnet(String subnetId, State subnetState, String vpcId, String cidrBlock, int availableIpAddressCount, String availabilityZone, ImmutableMap<String, String> tags) {
        this.subnetId = (String)Preconditions.checkNotNull((Object)subnetId, (Object)"subnetId");
        this.subnetState = (State)((Object)Preconditions.checkNotNull((Object)((Object)subnetState), (String)"subnetState for %s", (Object[])new Object[]{subnetId}));
        this.vpcId = (String)Preconditions.checkNotNull((Object)vpcId, (String)"vpcId for %s", (Object[])new Object[]{subnetId});
        this.cidrBlock = (String)Preconditions.checkNotNull((Object)cidrBlock, (String)"cidrBlock for %s", (Object[])new Object[]{subnetId});
        this.availableIpAddressCount = availableIpAddressCount;
        this.availabilityZone = (String)Preconditions.checkNotNull((Object)availabilityZone, (String)"availabilityZone for %s", (Object[])new Object[]{subnetId});
        this.tags = (Map)Preconditions.checkNotNull(tags, (String)"tags for %s", (Object[])new Object[]{subnetId});
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public State getSubnetState() {
        return this.subnetState;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public String getCidrBlock() {
        return this.cidrBlock;
    }

    public int getAvailableIpAddressCount() {
        return this.availableIpAddressCount;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.subnetId, this.vpcId, this.availabilityZone});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Subnet that = (Subnet)Subnet.class.cast(obj);
        return Objects.equal((Object)this.subnetId, (Object)that.subnetId) && Objects.equal((Object)this.vpcId, (Object)that.vpcId) && Objects.equal((Object)this.availabilityZone, (Object)that.availabilityZone);
    }

    public String toString() {
        return this.string().toString();
    }

    private final Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("subnetId", (Object)this.subnetId).add("subnetState", (Object)this.subnetState).add("vpcId", (Object)this.vpcId).add("cidrBlock", (Object)this.cidrBlock).add("availableIpAddressCount", this.availableIpAddressCount).add("availabilityZone", (Object)this.availabilityZone).add("tags", this.tags);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Subnet.builder().from(this);
    }

    public static final class Builder {
        private String subnetId;
        private State subnetState;
        private String vpcId;
        private String cidrBlock;
        private int availableIpAddressCount;
        private String availabilityZone;
        private ImmutableMap.Builder<String, String> tags = ImmutableMap.builder();

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public Builder subnetState(State subnetState) {
            this.subnetState = subnetState;
            return this;
        }

        public Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public Builder availableIpAddressCount(int availableIpAddressCount) {
            this.availableIpAddressCount = availableIpAddressCount;
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.tags.putAll((Map)Preconditions.checkNotNull(tags, (Object)"tags"));
            return this;
        }

        public Builder tag(String key) {
            return this.tag(key, "");
        }

        public Builder tag(String key, String value) {
            this.tags.put(Preconditions.checkNotNull((Object)key, (Object)"key"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this;
        }

        public Subnet build() {
            return new Subnet(this.subnetId, this.subnetState, this.vpcId, this.cidrBlock, this.availableIpAddressCount, this.availabilityZone, this.tags.build());
        }

        public Builder from(Subnet in) {
            return this.subnetId(in.getSubnetId()).subnetState(in.getSubnetState()).vpcId(in.getVpcId()).cidrBlock(in.getCidrBlock()).availableIpAddressCount(in.getAvailableIpAddressCount()).availabilityZone(in.getAvailabilityZone()).tags(in.getTags());
        }
    }

    public static enum State {
        AVAILABLE,
        PENDING,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public static State fromValue(String v) {
            try {
                return State.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

