/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.domain.AvailabilityZoneInfo;
import org.jclouds.ec2.options.DescribeAvailabilityZonesOptions;
import org.jclouds.ec2.services.AvailabilityZoneAndRegionClient;
import org.jclouds.http.HttpResponseException;
import org.jclouds.location.Region;
import org.jclouds.location.suppliers.RegionIdToZoneIdsSupplier;
import org.jclouds.logging.Logger;
import org.jclouds.util.Suppliers2;

@Singleton
public class DescribeAvailabilityZonesInRegion
implements RegionIdToZoneIdsSupplier {
    @Resource
    protected Logger logger = Logger.NULL;
    private final AvailabilityZoneAndRegionClient client;
    private final Supplier<Set<String>> regions;

    @Inject
    public DescribeAvailabilityZonesInRegion(EC2Client client, @Region Supplier<Set<String>> regions) {
        this.client = client.getAvailabilityZoneAndRegionServices();
        this.regions = regions;
    }

    public Map<String, Supplier<Set<String>>> get() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        HttpResponseException exception = null;
        for (String region : (Set)this.regions.get()) {
            try {
                ImmutableSet zones = ImmutableSet.copyOf((Iterable)Iterables.transform(this.client.describeAvailabilityZonesInRegion(region, new DescribeAvailabilityZonesOptions[0]), (Function)new Function<AvailabilityZoneInfo, String>(){

                    public String apply(AvailabilityZoneInfo arg0) {
                        return arg0.getZone();
                    }
                }));
                if (zones.size() <= 0) continue;
                map.put((Object)region, (Object)zones);
            }
            catch (HttpResponseException e) {
                if (e.getMessage().contains("Unable to tunnel through proxy")) {
                    exception = e;
                    this.logger.error((Throwable)e, "Could not describe availability zones in Region: %s", new Object[]{region});
                    continue;
                }
                throw e;
            }
        }
        ImmutableMap result = map.build();
        if (result.isEmpty() && exception != null) {
            throw exception;
        }
        return Maps.transformValues((Map)result, (Function)Suppliers2.ofInstanceFunction());
    }
}

