/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import org.jclouds.ec2.domain.IpPermission;
import org.jclouds.ec2.domain.IpProtocol;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.SAXException;

public class IpPermissionHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<IpPermission> {
    private StringBuilder currentText = new StringBuilder();
    private IpPermission.Builder builder = IpPermission.builder();
    private String userId;
    private String groupId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpPermission getResult() {
        try {
            IpPermission ipPermission = this.builder.build();
            return ipPermission;
        }
        finally {
            this.builder = IpPermission.builder();
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"ipProtocol")) {
            this.builder.ipProtocol(IpProtocol.fromValue(IpPermissionHandler.currentOrNegative(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"fromPort")) {
            this.builder.fromPort(Integer.parseInt(IpPermissionHandler.currentOrNegative(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"toPort")) {
            this.builder.toPort(Integer.parseInt(IpPermissionHandler.currentOrNegative(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"cidrIp")) {
            this.builder.ipRange(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"userId")) {
            this.userId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"groupName") || SaxUtils.equalsOrSuffix((String)qName, (String)"groupId")) {
            this.groupId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"item")) {
            if (this.userId != null && this.groupId != null) {
                this.builder.userIdGroupPair(this.userId, this.groupId);
            }
            this.groupId = null;
            this.userId = null;
        }
        this.currentText = new StringBuilder();
    }

    private static String currentOrNegative(StringBuilder currentText) {
        String returnVal = currentText.toString().trim();
        return returnVal.equals("") ? "-1" : returnVal;
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

