/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.elasticstack.domain.CreateDriveRequest;
import org.jclouds.elasticstack.domain.Drive;
import org.jclouds.elasticstack.functions.BaseDriveToMap;

@Singleton
public class CreateDriveRequestToMap
implements Function<Drive, Map<String, String>> {
    private final BaseDriveToMap baseDriveToMap;

    @Inject
    public CreateDriveRequestToMap(BaseDriveToMap baseDriveToMap) {
        this.baseDriveToMap = baseDriveToMap;
    }

    public Map<String, String> apply(Drive from) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(this.baseDriveToMap.apply(from));
        if (from instanceof CreateDriveRequest) {
            CreateDriveRequest create = (CreateDriveRequest)CreateDriveRequest.class.cast(from);
            if (create.getAvoid().size() != 0) {
                builder.put((Object)"avoid", (Object)Joiner.on((char)' ').join(create.getAvoid()));
            }
            if (create.getEncryptionCipher() != null) {
                builder.put((Object)"encryption:cipher", (Object)create.getEncryptionCipher());
            }
        }
        return builder.build();
    }
}

