/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.features;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Set;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.cinder.v1.CinderApi;
import org.jclouds.openstack.cinder.v1.domain.Snapshot;
import org.jclouds.openstack.cinder.v1.domain.Volume;
import org.jclouds.openstack.cinder.v1.features.SnapshotApi;
import org.jclouds.openstack.cinder.v1.internal.BaseCinderApiExpectTest;
import org.jclouds.openstack.cinder.v1.options.CreateSnapshotOptions;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SnapshotApiExpectTest")
public class SnapshotApiExpectTest
extends BaseCinderApiExpectTest {
    private DateService dateService = new SimpleDateFormatDateService();

    public void testListSnapshots() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/snapshots");
        SnapshotApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/snapshot_list_simple.json"))).build())).getSnapshotApiForZone("RegionOne");
        ImmutableSet snapshots = api.list().toSet();
        Assert.assertEquals((Set)snapshots, (Set)ImmutableSet.of((Object)this.testSnapshot()));
    }

    public void testListSnapshotsFail() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/snapshots");
        SnapshotApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getSnapshotApiForZone("RegionOne");
        ImmutableSet snapshots = api.list().toSet();
        Assert.assertTrue((boolean)snapshots.isEmpty());
    }

    public void testListSnapshotsInDetail() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/snapshots/detail");
        SnapshotApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/snapshot_list_details.json"))).build())).getSnapshotApiForZone("RegionOne");
        ImmutableSet snapshots = api.listInDetail().toSet();
        Assert.assertEquals((Set)snapshots, (Set)ImmutableSet.of((Object)this.testSnapshot()));
        Snapshot snappy = (Snapshot)Iterables.getOnlyElement((Iterable)snapshots);
        Assert.assertEquals((String)snappy.getId(), (String)"67d03df1-ce5d-4ba7-adbe-492ceb80170b");
        Assert.assertEquals((String)snappy.getVolumeId(), (String)"ea6f70ef-2784-40b9-9d14-d7f33c507c3f");
        Assert.assertEquals((Object)snappy.getStatus(), (Object)Volume.Status.AVAILABLE);
        Assert.assertEquals((String)snappy.getDescription(), (String)"jclouds test snapshot");
        Assert.assertEquals((String)snappy.getName(), (String)"jclouds-test-snapshot");
        Assert.assertEquals((int)snappy.getSize(), (int)1);
    }

    public void testListSnapshotsInDetailFail() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/snapshots/detail");
        SnapshotApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getSnapshotApiForZone("RegionOne");
        ImmutableSet snapshots = api.listInDetail().toSet();
        Assert.assertTrue((boolean)snapshots.isEmpty());
    }

    public void testGetSnapshot() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/snapshots/67d03df1-ce5d-4ba7-adbe-492ceb80170b");
        SnapshotApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/snapshot_get.json"))).build())).getSnapshotApiForZone("RegionOne");
        Snapshot snapshot = api.get("67d03df1-ce5d-4ba7-adbe-492ceb80170b");
        Assert.assertEquals((Object)snapshot, (Object)this.testSnapshot());
    }

    public void testGetSnapshotFail() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/snapshots/67d03df1-ce5d-4ba7-adbe-492ceb80170b");
        SnapshotApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getSnapshotApiForZone("RegionOne");
        Assert.assertNull((Object)api.get("67d03df1-ce5d-4ba7-adbe-492ceb80170b"));
    }

    public void testCreateSnapshot() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/snapshots");
        SnapshotApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(this.payloadFromResourceWithContentType("/snapshot_create.json", "application/json"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/snapshot_create_response.json"))).build())).getSnapshotApiForZone("RegionOne");
        CreateSnapshotOptions options = CreateSnapshotOptions.Builder.name((String)"jclouds-test-snapshot").description("jclouds test snapshot").force();
        Snapshot snapshot = api.create("ea6f70ef-2784-40b9-9d14-d7f33c507c3f", new CreateSnapshotOptions[]{options});
        Assert.assertEquals((Object)snapshot, (Object)this.testSnapshotCreate());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testCreateSnapshotVolumeNotFoundFail() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/snapshots");
        SnapshotApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(this.payloadFromResourceWithContentType("/snapshot_create.json", "application/json"))).build(), HttpResponse.builder().statusCode(404).build())).getSnapshotApiForZone("RegionOne");
        CreateSnapshotOptions options = CreateSnapshotOptions.Builder.name((String)"jclouds-test-snapshot").description("jclouds test snapshot").force();
        api.create("ea6f70ef-2784-40b9-9d14-d7f33c507c3f", new CreateSnapshotOptions[]{options});
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testCreateSnapshotVolumeIllegalStateFail() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/snapshots");
        SnapshotApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(this.payloadFromResourceWithContentType("/snapshot_create.json", "application/json"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(400).payload("{\"badRequest\": {\"message\": \"Invalid volume: must be available\", \"code\": 400}}")).build())).getSnapshotApiForZone("RegionOne");
        CreateSnapshotOptions options = CreateSnapshotOptions.Builder.name((String)"jclouds-test-snapshot").description("jclouds test snapshot").force();
        api.create("ea6f70ef-2784-40b9-9d14-d7f33c507c3f", new CreateSnapshotOptions[]{options});
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testCreateSnapshotFail() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/snapshots");
        SnapshotApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(this.payloadFromResourceWithContentType("/snapshot_create.json", "application/json"))).build(), HttpResponse.builder().statusCode(401).build())).getSnapshotApiForZone("RegionOne");
        CreateSnapshotOptions options = CreateSnapshotOptions.Builder.name((String)"jclouds-test-snapshot").description("jclouds test snapshot").force();
        api.create("ea6f70ef-2784-40b9-9d14-d7f33c507c3f", new CreateSnapshotOptions[]{options});
    }

    public void testDeleteSnapshot() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/snapshots/67d03df1-ce5d-4ba7-adbe-492ceb80170b");
        SnapshotApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), HttpResponse.builder().statusCode(200).build())).getSnapshotApiForZone("RegionOne");
        Assert.assertTrue((boolean)api.delete("67d03df1-ce5d-4ba7-adbe-492ceb80170b"));
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testDeleteSnapshotFail() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/snapshots/67d03df1-ce5d-4ba7-adbe-492ceb80170b");
        SnapshotApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), HttpResponse.builder().statusCode(401).build())).getSnapshotApiForZone("RegionOne");
        api.delete("67d03df1-ce5d-4ba7-adbe-492ceb80170b");
    }

    public void testDeleteSnapshotNotFoundFail() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/snapshots/67d03df1-ce5d-4ba7-adbe-492ceb80170b");
        SnapshotApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), HttpResponse.builder().statusCode(404).build())).getSnapshotApiForZone("RegionOne");
        Assert.assertFalse((boolean)api.delete("67d03df1-ce5d-4ba7-adbe-492ceb80170b"));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testDeleteSnapshotIllegalStateFail() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/snapshots/67d03df1-ce5d-4ba7-adbe-492ceb80170b");
        SnapshotApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(400).payload("{\"badRequest\": {\"message\": \"Invalid volume: Volume Snapshot status must be available or error\", \"code\": 400}}")).build())).getSnapshotApiForZone("RegionOne");
        api.delete("67d03df1-ce5d-4ba7-adbe-492ceb80170b");
    }

    protected Snapshot testSnapshotCreate() {
        return Snapshot.builder().id("67d03df1-ce5d-4ba7-adbe-492ceb80170b").volumeId("ea6f70ef-2784-40b9-9d14-d7f33c507c3f").description("jclouds test snapshot").status(Volume.Status.CREATING).name("jclouds-test-snapshot").size(1).created(this.dateService.iso8601DateParse("2012-11-02T16:23:27.000000")).build();
    }

    protected Snapshot testSnapshot() {
        return Snapshot.builder().id("67d03df1-ce5d-4ba7-adbe-492ceb80170b").volumeId("ea6f70ef-2784-40b9-9d14-d7f33c507c3f").description("jclouds test snapshot").status(Volume.Status.AVAILABLE).name("jclouds-test-snapshot").size(1).created(this.dateService.iso8601DateParse("2012-11-02T16:23:27.000000")).build();
    }
}

