/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.features;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.cinder.v1.CinderApi;
import org.jclouds.openstack.cinder.v1.domain.VolumeType;
import org.jclouds.openstack.cinder.v1.features.VolumeTypeApi;
import org.jclouds.openstack.cinder.v1.internal.BaseCinderApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VolumeTypeApiExpectTest")
public class VolumeTypeApiExpectTest
extends BaseCinderApiExpectTest {
    private DateService dateService = new SimpleDateFormatDateService();

    public void testListVolumeTypes() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/types");
        VolumeTypeApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/volume_type_list_simple.json"))).build())).getVolumeTypeApiForZone("RegionOne");
        ImmutableSet types = api.list().toSet();
        Assert.assertEquals((Set)types, (Set)ImmutableSet.of((Object)this.testVolumeType()));
    }

    public void testGetVolumeType() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/types/1");
        VolumeTypeApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/volume_type_get.json"))).build())).getVolumeTypeApiForZone("RegionOne");
        VolumeType type = api.get("1");
        Assert.assertEquals((Object)type, (Object)this.testVolumeType());
    }

    public void testGetVolumeTypeFailNotFound() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/types/X");
        VolumeTypeApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getVolumeTypeApiForZone("RegionOne");
        Assert.assertNull((Object)api.get("X"));
    }

    public VolumeType testVolumeType() {
        return VolumeType.builder().id("1").name("jclouds-test-1").created(this.dateService.iso8601SecondsDateParse("2012-05-10 12:33:06")).extraSpecs((Map)ImmutableMap.of((Object)"test", (Object)"value1", (Object)"test1", (Object)"wibble")).build();
    }
}

