/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.features.TenantApi;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneRestApiExpectTest;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rest.AuthorizationException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="TenantApiExpectTest")
public class TenantApiExpectTest
extends BaseKeystoneRestApiExpectTest<KeystoneApi> {
    Set<Tenant> expectedTenants = ImmutableSet.of((Object)Tenant.builder().name("demo").id("05d1dc7af71646deba64cfc17b81bec0").build(), (Object)Tenant.builder().name("admin").id("7aa2e17ec29f44d193c48feaba0852cc").build());

    public TenantApiExpectTest() {
        this.endpoint = "https://csnode.jclouds.org:35357";
    }

    public void testListTenants() {
        TenantApi api = (TenantApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/tenants").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/tenant_list.json", "application/json"))).build())).getTenantApi().get();
        Assert.assertEquals((Set)api.list().concat().toSet(), this.expectedTenants);
    }

    public void testListTenantsPage() {
        TenantApi api = (TenantApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/tenants").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/tenant_list.json", "application/json"))).build())).getTenantApi().get();
        ImmutableSet tenants = api.list(new PaginationOptions()).toSet();
        Assert.assertNotNull((Object)tenants);
        Assert.assertFalse((boolean)tenants.isEmpty());
        Assert.assertEquals((Set)tenants, this.expectedTenants);
    }

    @Test(enabled=false)
    public void testListTenantsATT() {
        TenantApi api = (TenantApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/tenants").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/tenant_list_att.json", "application/json"))).build())).getTenantApi().get();
        ImmutableSet expected = ImmutableSet.of((Object)Tenant.builder().name("this-is-a-test").id("14").description("None").build());
        Assert.assertEquals((Set)api.list().concat().toSet(), (Set)expected);
    }

    @Test(enabled=false)
    public void testListTenantsFailNotFound() {
        TenantApi api = (TenantApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/tenants").build(), HttpResponse.builder().statusCode(404).build())).getTenantApi().get();
        Assert.assertTrue((boolean)api.list().isEmpty());
    }

    public void testGetTenant() {
        TenantApi api = (TenantApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/tenants/013ba41150a14830bec85ffe93353bcc").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/tenant_details.json", "application/json"))).build())).getTenantApi().get();
        Tenant tenant = api.get("013ba41150a14830bec85ffe93353bcc");
        Assert.assertNotNull((Object)tenant);
        Assert.assertEquals((Object)tenant, (Object)Tenant.builder().id("013ba41150a14830bec85ffe93353bcc").name("admin").build());
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testListTenantsFailNotAuthorized() {
        TenantApi api = (TenantApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/tenants/013ba41150a14830bec85ffe93353bcc").build(), HttpResponse.builder().statusCode(401).build())).getTenantApi().get();
        api.get("013ba41150a14830bec85ffe93353bcc");
    }

    public void testGetTenantByName() {
        TenantApi api = (TenantApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/tenants?name=admin").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/tenant_details.json", "application/json"))).build())).getTenantApi().get();
        Tenant tenant = api.getByName("admin");
        Assert.assertNotNull((Object)tenant);
        Assert.assertEquals((Object)tenant, (Object)Tenant.builder().id("013ba41150a14830bec85ffe93353bcc").name("admin").build());
    }

    public void testGetTenantByNameFailNotFound() {
        TenantApi api = (TenantApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/tenants?name=admin").build(), HttpResponse.builder().statusCode(404).build())).getTenantApi().get();
        Assert.assertNull((Object)api.getByName("admin"));
    }
}

