/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.functions.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneParserModule;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.keystone.v2_0.functions.internal.ParseUsers;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="ParseUsersTest")
public class ParseUsersTest {
    private Gson gson = (Gson)Guice.createInjector((Module[])new Module[]{new GsonModule(), new KeystoneParserModule()}).getInstance(Gson.class);
    private Type usersMapType = new TypeToken<Map<String, Set<? extends User>>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    Set<User> expectedUsers = ImmutableSet.of((Object)User.builder().name("nova").id("e021dfd758eb44a89f1c57c8ef3be8e2").build(), (Object)User.builder().name("glance").id("3f6c1c9ba993495ead7d2eb2192e284f").build(), (Object)User.builder().name("demo").id("667b2e1420604df8b67cd8ea57d4ee64").build(), (Object)User.builder().name("admin").id("2b9b606181634ae9ac86fd95a8bc2cde").build());

    public void testParseUsersInMap() throws JsonSyntaxException, IOException {
        String json = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/user_list.json"));
        Map users = (Map)this.gson.fromJson(json, this.usersMapType);
        Assert.assertEquals((Set)((Set)users.get("users")), this.expectedUsers);
    }

    public void testParseUsers() throws JsonSyntaxException, IOException {
        String json = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/user_list.json"));
        ParseUsers.Users users = (ParseUsers.Users)this.gson.fromJson(json, ParseUsers.Users.class);
        Assert.assertEquals((Set)users.toSet(), this.expectedUsers);
    }
}

