/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.internal;

import com.google.common.base.Objects;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.keystone.v2_0.KeystoneApiMetadata;
import org.jclouds.openstack.keystone.v2_0.internal.KeystoneFixture;
import org.jclouds.rest.internal.BaseRestApiExpectTest;

public class BaseKeystoneRestApiExpectTest<S>
extends BaseRestApiExpectTest<S> {
    protected HttpRequest keystoneAuthWithUsernameAndPasswordAndTenantName;
    protected HttpRequest keystoneAuthWithUsernameAndPassword;
    protected HttpRequest keystoneAuthWithAccessKeyAndSecretKey;
    protected String authToken;
    protected HttpResponse responseWithKeystoneAccess;
    protected String endpoint = "http://localhost:5000";

    public BaseKeystoneRestApiExpectTest() {
        this.provider = "openstack-keystone";
        this.keystoneAuthWithUsernameAndPasswordAndTenantName = KeystoneFixture.INSTANCE.initialAuthWithUsernameAndPasswordAndTenantName(this.identity, this.credential);
        this.keystoneAuthWithUsernameAndPassword = KeystoneFixture.INSTANCE.initialAuthWithUsernameAndPassword(this.identity, this.credential);
        this.keystoneAuthWithAccessKeyAndSecretKey = KeystoneFixture.INSTANCE.initialAuthWithAccessKeyAndSecretKeyAndTenantName(this.identity, this.credential);
        this.authToken = KeystoneFixture.INSTANCE.getAuthToken();
        this.responseWithKeystoneAccess = KeystoneFixture.INSTANCE.responseWithAccess();
        this.identity = KeystoneFixture.INSTANCE.getTenantName() + ":" + this.identity;
    }

    protected HttpRequest.Builder<?> authenticatedGET() {
        return (HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken});
    }

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        props.put("jclouds.keystone.service-type", "identity");
        return props;
    }

    protected BaseRestApiExpectTest.HttpRequestComparisonType compareHttpRequestAsType(HttpRequest input) {
        return Objects.equal((Object)"HEAD", (Object)input.getMethod()) ? BaseRestApiExpectTest.HttpRequestComparisonType.DEFAULT : BaseRestApiExpectTest.HttpRequestComparisonType.JSON;
    }

    protected ApiMetadata createApiMetadata() {
        return new KeystoneApiMetadata();
    }
}

