/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Singleton;
import org.jclouds.location.Provider;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.domain.Endpoint;
import org.jclouds.openstack.keystone.v2_0.functions.EndpointToRegion;
import org.jclouds.openstack.keystone.v2_0.parse.ParseAccessTest;
import org.jclouds.openstack.keystone.v2_0.parse.ParseRackspaceAccessTest;
import org.jclouds.openstack.keystone.v2_0.suppliers.LocationIdToURIFromAccessForTypeAndVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="LocationIdToURIFromAccessForTypeAndVersionTest")
public class LocationIdToURIFromAccessForTypeAndVersionTest {
    private final LocationIdToURIFromAccessForTypeAndVersion.Factory factory = (LocationIdToURIFromAccessForTypeAndVersion.Factory)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bindConstant().annotatedWith(Provider.class).to("openstack-keystone");
            this.bind((TypeLiteral)new TypeLiteral<Supplier<URI>>(){}).annotatedWith(Provider.class).toInstance((Object)Suppliers.ofInstance((Object)URI.create("https://identity")));
            this.bind((TypeLiteral)new TypeLiteral<Function<Endpoint, String>>(){}).to(EndpointToRegion.class);
            this.install(new FactoryModuleBuilder().implement(LocationIdToURIFromAccessForTypeAndVersion.class, LocationIdToURIFromAccessForTypeAndVersion.class).build(LocationIdToURIFromAccessForTypeAndVersion.Factory.class));
        }

        @Provides
        @Singleton
        public Supplier<Access> provide() {
            return Suppliers.ofInstance((Object)new ParseAccessTest().expected());
        }
    }}).getInstance(LocationIdToURIFromAccessForTypeAndVersion.Factory.class);
    private final LocationIdToURIFromAccessForTypeAndVersion.Factory raxFactory = (LocationIdToURIFromAccessForTypeAndVersion.Factory)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bindConstant().annotatedWith(Provider.class).to("rackspace");
            this.bind((TypeLiteral)new TypeLiteral<Supplier<URI>>(){}).annotatedWith(Provider.class).toInstance((Object)Suppliers.ofInstance((Object)URI.create("https://identity")));
            this.bind((TypeLiteral)new TypeLiteral<Function<Endpoint, String>>(){}).to(EndpointToRegion.class);
            this.install(new FactoryModuleBuilder().implement(LocationIdToURIFromAccessForTypeAndVersion.class, LocationIdToURIFromAccessForTypeAndVersion.class).build(LocationIdToURIFromAccessForTypeAndVersion.Factory.class));
        }

        @Provides
        @Singleton
        public Supplier<Access> provide() {
            return Suppliers.ofInstance((Object)new ParseRackspaceAccessTest().expected());
        }
    }}).getInstance(LocationIdToURIFromAccessForTypeAndVersion.Factory.class);

    public void testRegionUnmatchesOkWhenNoVersionIdSet() {
        Assert.assertEquals((Map)Maps.transformValues((Map)this.factory.createForApiTypeAndVersion("compute", "1.1").get(), (Function)Suppliers.supplierFunction()), (Map)ImmutableMap.of((Object)"az-1.region-a.geo-1", (Object)URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456"), (Object)"az-2.region-a.geo-1", (Object)URI.create("https://az-2.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456"), (Object)"az-3.region-a.geo-1", (Object)URI.create("https://az-3.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456")));
    }

    public void testRegionMatches() {
        Assert.assertEquals((Map)Maps.transformValues((Map)this.factory.createForApiTypeAndVersion("compute", "1.1").get(), (Function)Suppliers.supplierFunction()), (Map)ImmutableMap.of((Object)"az-1.region-a.geo-1", (Object)URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456"), (Object)"az-2.region-a.geo-1", (Object)URI.create("https://az-2.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456"), (Object)"az-3.region-a.geo-1", (Object)URI.create("https://az-3.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456")));
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testWhenNotInList() {
        Assert.assertEquals((Map)Maps.transformValues((Map)this.raxFactory.createForApiTypeAndVersion("goo", "1.0").get(), (Function)Suppliers.supplierFunction()), (Map)ImmutableMap.of((Object)"rackspace", (Object)URI.create("https://servers.api.rackspacecloud.com/v1.0/40806637803162")));
    }

    public void testProviderWhenNoRegions() {
        Map withNoRegions = Maps.transformValues((Map)this.raxFactory.createForApiTypeAndVersion("compute", "1.0").get(), (Function)Suppliers.supplierFunction());
        Assert.assertEquals((Map)withNoRegions, (Map)ImmutableMap.of((Object)"rackspace", (Object)URI.create("https://servers.api.rackspacecloud.com/v1.0/40806637803162")));
    }

    public void testOkWithNoVersions() {
        Assert.assertEquals((Map)Maps.transformValues((Map)this.raxFactory.createForApiTypeAndVersion("rax:database", null).get(), (Function)Suppliers.supplierFunction()), (Map)ImmutableMap.of((Object)"DFW", (Object)URI.create("https://dfw.databases.api.rackspacecloud.com/v1.0/40806637803162"), (Object)"ORD", (Object)URI.create("https://ord.databases.api.rackspacecloud.com/v1.0/40806637803162")));
    }
}

