/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.v2_0.predicates;

import java.net.URI;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.openstack.v2_0.domain.Extension;
import org.jclouds.openstack.v2_0.predicates.ExtensionPredicates;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ExtensionPredicatesTest")
public class ExtensionPredicatesTest {
    Extension ref = ((Extension.Builder)Extension.builder().alias("os-keypairs").name("Keypairs")).namespace(URI.create("http://docs.openstack.org/ext/keypairs/api/v1.1")).updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2011-08-08T00:00:00+00:00")).description("Keypair Support").build();

    @Test
    public void testAliasEqualsWhenEqual() {
        assert (ExtensionPredicates.aliasEquals((String)"os-keypairs").apply((Object)this.ref));
    }

    @Test
    public void testAliasEqualsWhenNotEqual() {
        assert (!ExtensionPredicates.aliasEquals((String)"foo").apply((Object)this.ref));
    }

    @Test
    public void testNamespaceEqualsWhenEqual() {
        assert (ExtensionPredicates.namespaceEquals((URI)URI.create("http://docs.openstack.org/ext/keypairs/api/v1.1")).apply((Object)this.ref));
    }

    @Test
    public void testNamespaceEqualsWhenEqualEvenOnInputHttps() {
        assert (ExtensionPredicates.namespaceEquals((URI)URI.create("http://docs.openstack.org/ext/keypairs/api/v1.1")).apply((Object)this.ref.toBuilder().namespace(URI.create("https://docs.openstack.org/ext/keypairs/api/v1.1")).build()));
    }

    @Test
    public void testNamespaceEqualsWhenNotEqual() {
        assert (!ExtensionPredicates.namespaceEquals((URI)URI.create("foo")).apply((Object)this.ref));
    }
}

