/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.ec2.internal;

import com.google.inject.Module;
import com.google.inject.Provides;
import java.net.URI;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.ec2.NovaEC2Client;
import org.jclouds.openstack.nova.ec2.config.NovaEC2RestClientModule;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.internal.BaseRestClientExpectTest;

public abstract class BaseNovaEC2RestClientExpectTest
extends BaseRestClientExpectTest<NovaEC2Client> {
    protected static final String CONSTANT_DATE = "2012-04-16T15:54:08.897Z";
    protected DateService dateService = new SimpleDateFormatDateService();
    protected URI endpoint = URI.create("http://localhost:8773/services/Cloud/");
    protected HttpRequest describeAvailabilityZonesRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint(this.endpoint).addHeader("Host", new String[]{"localhost:8773"})).payload(BaseNovaEC2RestClientExpectTest.payloadFromStringWithContentType((String)"Action=DescribeAvailabilityZones&Signature=S3fa5fybw4KAq4o11IpKHlqwx3cVJdKfeAKw3FIJYvM%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Timestamp=2012-04-16T15%3A54%3A08.897Z&Version=2009-04-04&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build();
    protected HttpResponse describeAvailabilityZonesResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/nova_ec2_availabilityZones.xml", "application/xml"))).build();

    public BaseNovaEC2RestClientExpectTest() {
        this.provider = "openstack-nova-ec2";
    }

    protected Module createModule() {
        return new TestNovaEC2RestClientModule();
    }

    @ConfiguresRestClient
    private static final class TestNovaEC2RestClientModule
    extends NovaEC2RestClientModule {
        private TestNovaEC2RestClientModule() {
        }

        @Provides
        protected String provideTimeStamp(DateService dateService) {
            return BaseNovaEC2RestClientExpectTest.CONSTANT_DATE;
        }
    }
}

