/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.ec2.services;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.services.ElasticBlockStoreClient;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.ec2.NovaEC2Client;
import org.jclouds.openstack.nova.ec2.internal.BaseNovaEC2RestClientExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="NovaEC2ElasticBlockStoreClientTest")
public class NovaEC2ElasticBlockStoreExpectClientTest
extends BaseNovaEC2RestClientExpectTest {
    public void testDescribeVolumesWithNovaEC2Status() {
        ElasticBlockStoreClient client = ((NovaEC2Client)this.requestsSendResponses(this.describeAvailabilityZonesRequest, this.describeAvailabilityZonesResponse, ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("http://localhost:8773/services/Cloud/").addHeader("Host", new String[]{"localhost:8773"})).payload(NovaEC2ElasticBlockStoreExpectClientTest.payloadFromStringWithContentType((String)"Action=DescribeVolumes&Signature=AvRznSzGExM%2Buaj2JJj66wq4v4f%2BakicyLooRDtC0t0%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Timestamp=2012-04-16T15%3A54%3A08.897Z&Version=2009-04-04&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/nova_ec2_describe_volumes.xml"))).build())).getElasticBlockStoreServices();
        ImmutableSet expected = ImmutableSet.of((Object)Volume.builder().status(Volume.Status.AVAILABLE).availabilityZone("nova").region("nova").id("vol-00000007").size(1).attachments(new Attachment[]{Attachment.builder().region("nova").build()}).createTime(this.dateService.iso8601SecondsDateParse("2012-04-10T10:39:52Z")).build());
        Assert.assertEquals((Set)client.describeVolumesInRegion("nova", new String[0]), (Set)expected);
    }
}

