/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0;

import com.google.common.collect.ImmutableSet;
import java.util.Properties;
import java.util.Set;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="EndpointIdIsRandomExpectTest")
public class EndpointIdIsRandomExpectTest
extends BaseNovaApiExpectTest {
    public EndpointIdIsRandomExpectTest() {
        this.identity = "demo:demo";
        this.credential = "password";
    }

    protected Properties setupProperties() {
        Properties overrides = super.setupProperties();
        overrides.setProperty("jclouds.endpoint", "http://10.10.10.10:5000/v2.0/");
        return overrides;
    }

    public void testVersionMatchOnConfiguredZonesWhenResponseIs2xx() {
        HttpRequest authenticate = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("http://10.10.10.10:5000/v2.0/tokens").addHeader("Accept", new String[]{"application/json"})).payload(EndpointIdIsRandomExpectTest.payloadFromStringWithContentType((String)"{\"auth\":{\"passwordCredentials\":{\"username\":\"demo\",\"password\":\"password\"},\"tenantName\":\"demo\"}}", (String)"application/json"))).build();
        HttpResponse authenticationResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/access_version_uids.json", "application/json"))).build();
        NovaApi whenNovaRegionExists = (NovaApi)this.requestSendsResponse(authenticate, authenticationResponse);
        Assert.assertEquals((Set)whenNovaRegionExists.getConfiguredZones(), (Set)ImmutableSet.of((Object)"RegionOne"));
    }
}

