/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute;

import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.Properties;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.compute.NovaComputeServiceAdapter;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.jclouds.openstack.nova.v2_0.domain.KeyPair;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ServerInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndName;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaComputeServiceContextExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="NovaComputeServiceAdapterExpectTest")
public class NovaComputeServiceAdapterExpectTest
extends BaseNovaComputeServiceContextExpectTest<Injector> {
    HttpRequest serverDetail;
    HttpResponse serverDetailResponse;

    public NovaComputeServiceAdapterExpectTest() {
        this.serverDetail = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/71752").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        this.serverDetailResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/server_details.json"))).build();
    }

    public void testCreateNodeWithGroupEncodedIntoNameWithDiskConfig() throws Exception {
        HttpRequest createServer = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(NovaComputeServiceAdapterExpectTest.payloadFromStringWithContentType((String)"{\"server\":{\"name\":\"test-e92\",\"imageRef\":\"1241\",\"flavorRef\":\"100\",\"OS-DCF:diskConfig\":\"AUTO\"}}", (String)"application/json"))).build();
        HttpResponse createServerResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(202).message("HTTP/1.1 202 Accepted").payload(this.payloadFromResourceWithContentType("/new_server_disk_config_auto.json", "application/json; charset=UTF-8"))).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.keystoneAuthWithUsernameAndPasswordAndTenantName, (Object)this.responseWithKeystoneAccess).put((Object)this.extensionsOfNovaRequest, (Object)this.extensionsOfNovaResponse).put((Object)this.listDetail, (Object)this.listDetailResponse).put((Object)this.listFlavorsDetail, (Object)this.listFlavorsDetailResponse).put((Object)createServer, (Object)createServerResponse).put((Object)this.serverDetail, (Object)this.serverDetailResponse).build();
        Injector forDiskConfig = (Injector)this.requestsSendResponses((Map)requestResponseMap);
        Template template = ((TemplateBuilder)forDiskConfig.getInstance(TemplateBuilder.class)).build();
        ((NovaTemplateOptions)template.getOptions().as(NovaTemplateOptions.class)).diskConfig("AUTO");
        NovaComputeServiceAdapter adapter = (NovaComputeServiceAdapter)forDiskConfig.getInstance(NovaComputeServiceAdapter.class);
        ComputeServiceAdapter.NodeAndInitialCredentials server = adapter.createNodeWithGroupEncodedIntoName("test", "test-e92", template);
        Assert.assertNotNull((Object)server);
        Assert.assertEquals((String)((String)((ServerInZone)server.getNode()).getServer().getDiskConfig().orNull()), (String)"AUTO");
    }

    public void testCreateNodeWithGroupEncodedIntoNameWhenSecurityGroupsArePresent() throws Exception {
        HttpRequest createServer = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(NovaComputeServiceAdapterExpectTest.payloadFromStringWithContentType((String)"{\"server\":{\"name\":\"test-e92\",\"imageRef\":\"1241\",\"flavorRef\":\"100\",\"security_groups\":[{\"name\":\"group1\"}, {\"name\":\"group2\"}]}}", (String)"application/json"))).build();
        HttpResponse createServerResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(202).message("HTTP/1.1 202 Accepted").payload(this.payloadFromResourceWithContentType("/new_server.json", "application/json; charset=UTF-8"))).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.keystoneAuthWithUsernameAndPasswordAndTenantName, (Object)this.responseWithKeystoneAccess).put((Object)this.extensionsOfNovaRequest, (Object)this.extensionsOfNovaResponse).put((Object)this.listDetail, (Object)this.listDetailResponse).put((Object)this.listFlavorsDetail, (Object)this.listFlavorsDetailResponse).put((Object)createServer, (Object)createServerResponse).put((Object)this.serverDetail, (Object)this.serverDetailResponse).build();
        Injector forSecurityGroups = (Injector)this.requestsSendResponses((Map)requestResponseMap);
        Template template = ((TemplateBuilder)forSecurityGroups.getInstance(TemplateBuilder.class)).build();
        ((NovaTemplateOptions)template.getOptions().as(NovaTemplateOptions.class)).securityGroupNames(new String[]{"group1", "group2"});
        NovaComputeServiceAdapter adapter = (NovaComputeServiceAdapter)forSecurityGroups.getInstance(NovaComputeServiceAdapter.class);
        ComputeServiceAdapter.NodeAndInitialCredentials server = adapter.createNodeWithGroupEncodedIntoName("test", "test-e92", template);
        Assert.assertNotNull((Object)server);
        Assert.assertEquals((Object)server.getCredentials(), (Object)LoginCredentials.builder().password("ZWuHcmTMQ7eXoHeM").build());
    }

    public void testWhenKeyPairPresentWeUsePrivateKeyAsCredentialNotPassword() throws Exception {
        HttpRequest createServer = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(NovaComputeServiceAdapterExpectTest.payloadFromStringWithContentType((String)"{\"server\":{\"name\":\"test-e92\",\"imageRef\":\"1241\",\"flavorRef\":\"100\",\"key_name\":\"foo\"}}", (String)"application/json"))).build();
        HttpResponse createServerResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(202).message("HTTP/1.1 202 Accepted").payload(this.payloadFromResourceWithContentType("/new_server_no_adminpass.json", "application/json; charset=UTF-8"))).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.keystoneAuthWithUsernameAndPasswordAndTenantName, (Object)this.responseWithKeystoneAccess).put((Object)this.extensionsOfNovaRequest, (Object)this.extensionsOfNovaResponse).put((Object)this.listDetail, (Object)this.listDetailResponse).put((Object)this.listFlavorsDetail, (Object)this.listFlavorsDetailResponse).put((Object)createServer, (Object)createServerResponse).put((Object)this.serverDetail, (Object)this.serverDetailResponse).build();
        Injector forSecurityGroups = (Injector)this.requestsSendResponses((Map)requestResponseMap);
        Template template = ((TemplateBuilder)forSecurityGroups.getInstance(TemplateBuilder.class)).build();
        ((NovaTemplateOptions)template.getOptions().as(NovaTemplateOptions.class)).keyPairName("foo");
        NovaComputeServiceAdapter adapter = (NovaComputeServiceAdapter)forSecurityGroups.getInstance(NovaComputeServiceAdapter.class);
        LoadingCache keyPairCache = (LoadingCache)forSecurityGroups.getInstance(Key.get((TypeLiteral)new TypeLiteral<LoadingCache<ZoneAndName, KeyPair>>(){}));
        keyPairCache.put((Object)ZoneAndName.fromZoneAndName((String)"az-1.region-a.geo-1", (String)"foo"), (Object)KeyPair.builder().name("foo").privateKey("privateKey").build());
        ComputeServiceAdapter.NodeAndInitialCredentials server = adapter.createNodeWithGroupEncodedIntoName("test", "test-e92", template);
        Assert.assertNotNull((Object)server);
        Assert.assertEquals((Object)server.getCredentials(), (Object)LoginCredentials.builder().privateKey("privateKey").build());
    }

    public void testNoKeyPairOrAdminPass() throws Exception {
        HttpRequest createServer = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(NovaComputeServiceAdapterExpectTest.payloadFromStringWithContentType((String)"{\"server\":{\"name\":\"test-e92\",\"imageRef\":\"1241\",\"flavorRef\":\"100\"}}", (String)"application/json"))).build();
        HttpResponse createServerResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(202).message("HTTP/1.1 202 Accepted").payload(this.payloadFromResourceWithContentType("/new_server_no_adminpass.json", "application/json; charset=UTF-8"))).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.keystoneAuthWithUsernameAndPasswordAndTenantName, (Object)this.responseWithKeystoneAccess).put((Object)this.extensionsOfNovaRequest, (Object)this.extensionsOfNovaResponse).put((Object)this.listDetail, (Object)this.listDetailResponse).put((Object)this.listFlavorsDetail, (Object)this.listFlavorsDetailResponse).put((Object)createServer, (Object)createServerResponse).put((Object)this.serverDetail, (Object)this.serverDetailResponse).build();
        Injector forSecurityGroups = (Injector)this.requestsSendResponses((Map)requestResponseMap);
        Template template = ((TemplateBuilder)forSecurityGroups.getInstance(TemplateBuilder.class)).build();
        NovaComputeServiceAdapter adapter = (NovaComputeServiceAdapter)forSecurityGroups.getInstance(NovaComputeServiceAdapter.class);
        ComputeServiceAdapter.NodeAndInitialCredentials server = adapter.createNodeWithGroupEncodedIntoName("test", "test-e92", template);
        Assert.assertNotNull((Object)server);
        Assert.assertNull((Object)server.getCredentials());
    }

    public Injector apply(ComputeServiceContext input) {
        return input.utils().injector();
    }

    protected Properties setupProperties() {
        Properties overrides = super.setupProperties();
        overrides.setProperty("jclouds.zones", "az-1.region-a.geo-1");
        return overrides;
    }
}

