/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute;

import com.google.inject.Module;
import java.util.Properties;
import java.util.logging.Logger;
import org.jclouds.compute.internal.BaseComputeServiceLiveTest;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="NovaComputeServiceLiveTest")
public class NovaComputeServiceLiveTest
extends BaseComputeServiceLiveTest {
    public NovaComputeServiceLiveTest() {
        this.provider = "openstack-nova";
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }

    public void testOptionToNotBlock() {
    }

    @Test(enabled=true, dependsOnMethods={"testReboot"})
    public void testSuspendResume() throws Exception {
        try {
            super.testSuspendResume();
        }
        catch (AuthorizationException e) {
            Logger.getAnonymousLogger().info("testSuspendResume() threw, probably due to lack of privileges: " + e.getMessage());
        }
        catch (UnsupportedOperationException e) {
            Logger.getAnonymousLogger().info("testSuspendResume() threw, probably due to unavailable AdminActions extension: " + e.getMessage());
        }
    }

    @Test(enabled=true, dependsOnMethods={"testSuspendResume"})
    public void testGetNodesWithDetails() throws Exception {
        super.testGetNodesWithDetails();
    }

    @Test(enabled=true, dependsOnMethods={"testSuspendResume"})
    public void testListNodes() throws Exception {
        super.testListNodes();
    }

    @Test(enabled=true, dependsOnMethods={"testSuspendResume"})
    public void testListNodesByIds() throws Exception {
        super.testListNodesByIds();
    }

    @Test(enabled=true, dependsOnMethods={"testListNodes", "testGetNodesWithDetails", "testListNodesByIds"})
    public void testDestroyNodes() {
        super.testDestroyNodes();
    }

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        this.setIfTestSystemPropertyPresent(props, "jclouds.keystone.credential-type");
        this.setIfTestSystemPropertyPresent(props, "jclouds.openstack-nova.auto-create-floating-ips");
        return props;
    }
}

