/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.UUID;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.openstack.nova.v2_0.compute.functions.FlavorInZoneToHardware;
import org.jclouds.openstack.nova.v2_0.domain.Flavor;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.FlavorInZone;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="FlavorInZoneToHardwareTest")
public class FlavorInZoneToHardwareTest {
    Location provider = new LocationBuilder().scope(LocationScope.PROVIDER).id("openstack-nova").description("openstack-nova").build();
    Location zone = new LocationBuilder().id("az-1.region-a.geo-1").description("az-1.region-a.geo-1").scope(LocationScope.ZONE).parent(this.provider).build();
    Supplier<Map<String, Location>> locationIndex = Suppliers.ofInstance((Object)ImmutableMap.of((Object)"az-1.region-a.geo-1", (Object)this.zone));

    @Test
    public void testConversionWhereLocationFound() {
        UUID id = UUID.randomUUID();
        FlavorInZone flavorInZoneToConvert = new FlavorInZone(((Flavor.Builder)((Flavor.Builder)Flavor.builder().id(id.toString())).name("Test Flavor " + id)).ram(262144).disk(10000).vcpus(16).build(), "az-1.region-a.geo-1");
        Hardware converted = new FlavorInZoneToHardware(this.locationIndex).apply(flavorInZoneToConvert);
        Flavor flavorToConvert = flavorInZoneToConvert.getFlavor();
        Assert.assertEquals((String)converted.getName(), (String)flavorToConvert.getName());
        Assert.assertEquals((String)converted.getId(), (String)flavorInZoneToConvert.slashEncode());
        Assert.assertEquals((String)converted.getProviderId(), (String)flavorToConvert.getId());
        Assert.assertEquals((Object)converted.getLocation(), ((Map)this.locationIndex.get()).get("az-1.region-a.geo-1"));
        Assert.assertEquals((int)converted.getRam(), (int)flavorToConvert.getRam());
        Assert.assertNotNull((Object)converted.getProcessors());
        Assert.assertFalse((boolean)converted.getProcessors().isEmpty());
        Assert.assertEquals((Object)((Processor)converted.getProcessors().iterator().next()).getCores(), (Object)flavorToConvert.getVcpus());
        Assert.assertNotNull((Object)converted.getVolumes());
        Assert.assertFalse((boolean)converted.getVolumes().isEmpty());
        Assert.assertEquals((Object)((Volume)converted.getVolumes().iterator().next()).getSize(), (Object)Float.valueOf(flavorToConvert.getDisk()));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testConversionWhereLocationNotFound() {
        UUID id = UUID.randomUUID();
        FlavorInZone flavorInZoneToConvert = new FlavorInZone(((Flavor.Builder)((Flavor.Builder)Flavor.builder().id(id.toString())).name("Test Flavor " + id)).ram(262144).disk(10000).vcpus(16).build(), "South");
        new FlavorInZoneToHardware(this.locationIndex).apply(flavorInZoneToConvert);
    }
}

