/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.openstack.nova.v2_0.compute.functions.ImageToOperatingSystem;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ImageToOperatingSystemTest {
    ImageToOperatingSystem converterForUbuntu = new ImageToOperatingSystem((Map)ImmutableMap.of((Object)OsFamily.UBUNTU, (Object)ImmutableMap.of((Object)"lucid", (Object)"10.04", (Object)"maverick", (Object)"10.10", (Object)"natty", (Object)"11.04", (Object)"oneiric", (Object)"11.10")));

    @Test(dataProvider="getOsFamilyValues")
    public void testOsFamilyValues(OsFamily family) {
        Image imageToConvert = ((Image.Builder)((Image.Builder)Image.builder().id("id-" + family.name())).name(family.name())).build();
        ImageToOperatingSystem converter = new ImageToOperatingSystem(new HashMap());
        OperatingSystem convertedOs = converter.apply(imageToConvert);
        Assert.assertEquals((String)convertedOs.getName(), (String)imageToConvert.getName());
        Assert.assertEquals((Object)convertedOs.getFamily(), (Object)family);
        Assert.assertEquals((String)convertedOs.getDescription(), (String)imageToConvert.getName());
        Assert.assertEquals((String)convertedOs.getVersion(), null);
        Assert.assertEquals((String)convertedOs.getArch(), null);
        Assert.assertTrue((boolean)convertedOs.is64Bit());
    }

    @DataProvider
    public Object[][] getOsFamilyValues() {
        return (Object[][])Iterables.toArray((Iterable)Iterables.transform(Arrays.asList(OsFamily.values()), (Function)new Function<OsFamily, Object[]>(){

            public Object[] apply(OsFamily osFamily) {
                return new Object[]{osFamily};
            }
        }), Object[].class);
    }

    @Test
    public void testWindowsServer2008R2x64() {
        String name = "Windows Server 2008 R2 x64";
        Image imageToConvert = ((Image.Builder)((Image.Builder)Image.builder().id("id-" + name)).name(name)).build();
        HashMap osFamilyMap = Maps.newHashMap();
        osFamilyMap.put(OsFamily.WINDOWS, ImmutableMap.of((Object)"Server 2008 R2", (Object)"Server-2008-R2"));
        ImageToOperatingSystem converter = new ImageToOperatingSystem((Map)osFamilyMap);
        OperatingSystem convertedOs = converter.apply(imageToConvert);
        Assert.assertEquals((String)convertedOs.getName(), (String)imageToConvert.getName());
        Assert.assertEquals((Object)convertedOs.getFamily(), (Object)OsFamily.WINDOWS);
        Assert.assertEquals((String)convertedOs.getDescription(), (String)imageToConvert.getName());
        Assert.assertEquals((String)convertedOs.getVersion(), (String)"Server-2008-R2");
        Assert.assertEquals((String)convertedOs.getArch(), null);
        Assert.assertTrue((boolean)convertedOs.is64Bit());
    }

    @Test
    public void testWindows98x86() {
        String name = "Windows 98 x86";
        Image imageToConvert = ((Image.Builder)((Image.Builder)Image.builder().id("id-" + name)).name(name)).build();
        HashMap osFamilyMap = Maps.newHashMap();
        osFamilyMap.put(OsFamily.WINDOWS, ImmutableMap.of((Object)"98", (Object)"98"));
        ImageToOperatingSystem converter = new ImageToOperatingSystem((Map)osFamilyMap);
        OperatingSystem convertedOs = converter.apply(imageToConvert);
        Assert.assertEquals((String)convertedOs.getName(), (String)imageToConvert.getName());
        Assert.assertEquals((Object)convertedOs.getFamily(), (Object)OsFamily.WINDOWS);
        Assert.assertEquals((String)convertedOs.getDescription(), (String)imageToConvert.getName());
        Assert.assertEquals((String)convertedOs.getVersion(), (String)"98");
        Assert.assertEquals((String)convertedOs.getArch(), null);
        Assert.assertFalse((boolean)convertedOs.is64Bit());
    }

    @Test
    public void testRHEL() {
        String name = "Red Hat EL";
        Image imageToConvert = ((Image.Builder)((Image.Builder)Image.builder().id("id-" + name)).name(name)).build();
        ImageToOperatingSystem converter = new ImageToOperatingSystem(new HashMap());
        OperatingSystem convertedOs = converter.apply(imageToConvert);
        Assert.assertEquals((String)convertedOs.getName(), (String)imageToConvert.getName());
        Assert.assertEquals((Object)convertedOs.getFamily(), (Object)OsFamily.RHEL);
        Assert.assertEquals((String)convertedOs.getDescription(), (String)imageToConvert.getName());
        Assert.assertEquals((String)convertedOs.getVersion(), null);
        Assert.assertEquals((String)convertedOs.getArch(), null);
        Assert.assertTrue((boolean)convertedOs.is64Bit());
    }

    @Test
    public void testOEL() {
        String name = "Oracle EL";
        Image imageToConvert = ((Image.Builder)((Image.Builder)Image.builder().id("id-" + name)).name(name)).build();
        ImageToOperatingSystem converter = new ImageToOperatingSystem(new HashMap());
        OperatingSystem convertedOs = converter.apply(imageToConvert);
        Assert.assertEquals((String)convertedOs.getName(), (String)imageToConvert.getName());
        Assert.assertEquals((Object)convertedOs.getFamily(), (Object)OsFamily.OEL);
        Assert.assertEquals((String)convertedOs.getDescription(), (String)imageToConvert.getName());
        Assert.assertEquals((String)convertedOs.getVersion(), null);
        Assert.assertEquals((String)convertedOs.getArch(), null);
        Assert.assertTrue((boolean)convertedOs.is64Bit());
    }

    @Test
    public void testTryStackOneric() {
        String name = "oneiric-server-cloudimg-amd64";
        Image imageToConvert = ((Image.Builder)((Image.Builder)Image.builder().id("id-" + name)).name(name)).build();
        OperatingSystem convertedOs = this.converterForUbuntu.apply(imageToConvert);
        Assert.assertEquals((String)convertedOs.getName(), (String)imageToConvert.getName());
        Assert.assertEquals((Object)convertedOs.getFamily(), (Object)OsFamily.UBUNTU);
        Assert.assertEquals((String)convertedOs.getDescription(), (String)imageToConvert.getName());
        Assert.assertEquals((String)convertedOs.getVersion(), (String)"11.10");
        Assert.assertEquals((String)convertedOs.getArch(), null);
        Assert.assertTrue((boolean)convertedOs.is64Bit());
    }

    @Test
    public void testTryStackNatty() {
        String name = "natty-server-cloudimg-amd64";
        Image imageToConvert = ((Image.Builder)((Image.Builder)Image.builder().id("id-" + name)).name(name)).build();
        OperatingSystem convertedOs = this.converterForUbuntu.apply(imageToConvert);
        Assert.assertEquals((String)convertedOs.getName(), (String)imageToConvert.getName());
        Assert.assertEquals((Object)convertedOs.getFamily(), (Object)OsFamily.UBUNTU);
        Assert.assertEquals((String)convertedOs.getDescription(), (String)imageToConvert.getName());
        Assert.assertEquals((String)convertedOs.getVersion(), (String)"11.04");
        Assert.assertEquals((String)convertedOs.getArch(), null);
        Assert.assertTrue((boolean)convertedOs.is64Bit());
    }
}

