/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.openstack.nova.v2_0.compute.config.NovaComputeServiceContextModule;
import org.jclouds.openstack.nova.v2_0.compute.functions.OrphanedGroupsByZoneId;
import org.jclouds.openstack.nova.v2_0.compute.functions.ServerInZoneToNodeMetadata;
import org.jclouds.openstack.nova.v2_0.compute.functions.ServerInZoneToNodeMetadataTest;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ServerInZone;
import org.jclouds.openstack.nova.v2_0.parse.ParseServerTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="OrphanedGroupsByZoneIdTest")
public class OrphanedGroupsByZoneIdTest {
    Location provider = new LocationBuilder().scope(LocationScope.PROVIDER).id("openstack-nova").description("openstack-nova").build();
    Location zone = new LocationBuilder().id("az-1.region-a.geo-1").description("az-1.region-a.geo-1").scope(LocationScope.ZONE).parent(this.provider).build();
    Supplier<Map<String, Location>> locationIndex = Suppliers.ofInstance((Object)ImmutableMap.of((Object)"az-1.region-a.geo-1", (Object)this.zone));
    GroupNamingConvention.Factory namingConvention = (GroupNamingConvention.Factory)Guice.createInjector((Module[])new Module[0]).getInstance(GroupNamingConvention.Factory.class);

    @Test
    public void testWhenComputeServiceSaysAllNodesAreDeadBothGroupsAreReturned() {
        ServerInZone withoutHost = new ServerInZone(new ServerInZoneToNodeMetadataTest().expectedServer(), "az-1.region-a.geo-1");
        ServerInZone withHost = new ServerInZone(new ParseServerTest().expected(), "az-1.region-a.geo-1");
        ServerInZoneToNodeMetadata converter = new ServerInZoneToNodeMetadata(NovaComputeServiceContextModule.toPortableNodeStatus, this.locationIndex, Suppliers.ofInstance((Object)ImmutableSet.of()), Suppliers.ofInstance((Object)ImmutableSet.of()), this.namingConvention);
        ImmutableSet set = ImmutableSet.of((Object)converter.apply(withHost), (Object)converter.apply(withoutHost));
        Assert.assertEquals((Object)new OrphanedGroupsByZoneId(Predicates.alwaysTrue()).apply((Set)set), (Object)ImmutableMultimap.builder().putAll((Object)"az-1.region-a.geo-1", (Object[])new String[]{"sample", "test"}).build());
    }

    @Test
    public void testWhenComputeServiceSaysAllNodesAreDeadNoGroupsAreReturned() {
        ServerInZone withoutHost = new ServerInZone(new ServerInZoneToNodeMetadataTest().expectedServer(), "az-1.region-a.geo-1");
        ServerInZone withHost = new ServerInZone(new ParseServerTest().expected(), "az-1.region-a.geo-1");
        ServerInZoneToNodeMetadata converter = new ServerInZoneToNodeMetadata(NovaComputeServiceContextModule.toPortableNodeStatus, this.locationIndex, Suppliers.ofInstance((Object)ImmutableSet.of()), Suppliers.ofInstance((Object)ImmutableSet.of()), this.namingConvention);
        ImmutableSet set = ImmutableSet.of((Object)converter.apply(withHost), (Object)converter.apply(withoutHost));
        Assert.assertEquals((Object)new OrphanedGroupsByZoneId(Predicates.alwaysFalse()).apply((Set)set), (Object)ImmutableMultimap.of());
    }
}

