/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.loaders;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.net.UnknownHostException;
import org.easymock.EasyMock;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.compute.loaders.CreateUniqueKeyPair;
import org.jclouds.openstack.nova.v2_0.domain.KeyPair;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndName;
import org.jclouds.openstack.nova.v2_0.extensions.KeyPairApi;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CreateUniqueKeyPairTest")
public class CreateUniqueKeyPairTest {
    @Test
    public void testApply() throws UnknownHostException {
        final NovaApi api = (NovaApi)EasyMock.createMock(NovaApi.class);
        KeyPairApi keyApi = (KeyPairApi)EasyMock.createMock(KeyPairApi.class);
        KeyPair pair = (KeyPair)EasyMock.createMock(KeyPair.class);
        Optional optKeyApi = Optional.of((Object)keyApi);
        EasyMock.expect((Object)api.getKeyPairExtensionForZone("zone")).andReturn((Object)optKeyApi).atLeastOnce();
        EasyMock.expect((Object)keyApi.create("group-1")).andReturn((Object)pair);
        EasyMock.replay((Object[])new Object[]{api, keyApi});
        CreateUniqueKeyPair parser = (CreateUniqueKeyPair)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).toInstance((Object)Suppliers.ofInstance((Object)"1"));
                this.bind(NovaApi.class).toInstance((Object)api);
            }
        }}).getInstance(CreateUniqueKeyPair.class);
        Assert.assertEquals((Object)parser.load(ZoneAndName.fromZoneAndName((String)"zone", (String)"group")), (Object)pair);
        EasyMock.verify((Object[])new Object[]{api, keyApi});
    }

    @Test
    public void testApplyWithIllegalStateException() throws UnknownHostException {
        final NovaApi api = (NovaApi)EasyMock.createMock(NovaApi.class);
        KeyPairApi keyApi = (KeyPairApi)EasyMock.createMock(KeyPairApi.class);
        final Supplier uniqueIdSupplier = (Supplier)EasyMock.createMock(Supplier.class);
        KeyPair pair = (KeyPair)EasyMock.createMock(KeyPair.class);
        EasyMock.expect((Object)api.getKeyPairExtensionForZone("zone")).andReturn((Object)Optional.of((Object)keyApi)).atLeastOnce();
        EasyMock.expect((Object)uniqueIdSupplier.get()).andReturn((Object)"1");
        EasyMock.expect((Object)keyApi.create("group-1")).andThrow((Throwable)new IllegalStateException());
        EasyMock.expect((Object)uniqueIdSupplier.get()).andReturn((Object)"2");
        EasyMock.expect((Object)keyApi.create("group-2")).andReturn((Object)pair);
        EasyMock.replay((Object[])new Object[]{api, keyApi, uniqueIdSupplier});
        CreateUniqueKeyPair parser = (CreateUniqueKeyPair)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).toInstance((Object)uniqueIdSupplier);
                this.bind(NovaApi.class).toInstance((Object)api);
            }
        }}).getInstance(CreateUniqueKeyPair.class);
        Assert.assertEquals((Object)parser.load(ZoneAndName.fromZoneAndName((String)"zone", (String)"group")), (Object)pair);
        EasyMock.verify((Object[])new Object[]{api, keyApi, uniqueIdSupplier});
    }
}

