/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.options;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="NovaTemplateOptionsTest")
public class NovaTemplateOptionsTest {
    public void testAs() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        Assert.assertEquals((Object)options.as(NovaTemplateOptions.class), (Object)options);
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="all security groups must be non-empty")
    public void testsecurityGroupNamesIterableBadFormat() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        options.securityGroupNames((Iterable)ImmutableSet.of((Object)"group1", (Object)""));
    }

    @Test
    public void testsecurityGroupNamesIterable() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        options.securityGroupNames((Iterable)ImmutableSet.of((Object)"group1", (Object)"group2"));
        Assert.assertEquals((Object)options.getSecurityGroupNames(), (Object)Optional.of((Object)ImmutableSet.of((Object)"group1", (Object)"group2")));
    }

    @Test
    public void testsecurityGroupNamesIterableStatic() {
        NovaTemplateOptions options = NovaTemplateOptions.Builder.securityGroupNames((Iterable)ImmutableSet.of((Object)"group1", (Object)"group2"));
        Assert.assertEquals((Object)options.getSecurityGroupNames(), (Object)Optional.of((Object)ImmutableSet.of((Object)"group1", (Object)"group2")));
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="all security groups must be non-empty")
    public void testsecurityGroupNamesVarArgsBadFormat() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        options.securityGroupNames(new String[]{"mygroup", ""});
    }

    @Test
    public void testsecurityGroupNamesVarArgs() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        options.securityGroupNames(new String[]{"group1", "group2"});
        Assert.assertEquals((Object)options.getSecurityGroupNames(), (Object)Optional.of((Object)ImmutableSet.of((Object)"group1", (Object)"group2")));
    }

    @Test
    public void testDefaultGroupsVarArgsEmpty() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        Assert.assertEquals((Object)options.getSecurityGroupNames(), (Object)Optional.absent());
    }

    @Test
    public void testsecurityGroupNamesVarArgsStatic() {
        NovaTemplateOptions options = NovaTemplateOptions.Builder.securityGroupNames((String[])new String[]{"group1", "group2"});
        Assert.assertEquals((Object)options.getSecurityGroupNames(), (Object)Optional.of((Object)ImmutableSet.of((Object)"group1", (Object)"group2")));
    }

    @Test
    public void testautoAssignFloatingIpDefault() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        assert (!options.shouldAutoAssignFloatingIp());
    }

    @Test
    public void testautoAssignFloatingIp() {
        NovaTemplateOptions options = new NovaTemplateOptions().autoAssignFloatingIp(true);
        assert (options.shouldAutoAssignFloatingIp());
    }

    @Test
    public void testautoAssignFloatingIpStatic() {
        NovaTemplateOptions options = NovaTemplateOptions.Builder.autoAssignFloatingIp((boolean)true);
        assert (options.shouldAutoAssignFloatingIp());
    }

    @Test
    public void testGenerateKeyPairDefault() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        assert (!options.shouldGenerateKeyPair());
    }

    @Test
    public void testGenerateKeyPair() {
        NovaTemplateOptions options = new NovaTemplateOptions().generateKeyPair(true);
        assert (options.shouldGenerateKeyPair());
    }

    @Test
    public void testGenerateKeyPairStatic() {
        NovaTemplateOptions options = NovaTemplateOptions.Builder.generateKeyPair((boolean)true);
        assert (options.shouldGenerateKeyPair());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testinstallPrivateKeyBadFormat() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        options.installPrivateKey("whompy");
    }

    @Test
    public void testinstallPrivateKey() throws IOException {
        NovaTemplateOptions options = new NovaTemplateOptions();
        options.installPrivateKey("-----BEGIN RSA PRIVATE KEY-----");
        Assert.assertEquals((String)options.getPrivateKey(), (String)"-----BEGIN RSA PRIVATE KEY-----");
    }

    @Test
    public void testNullinstallPrivateKey() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        Assert.assertEquals((String)options.getPrivateKey(), null);
    }

    @Test
    public void testinstallPrivateKeyStatic() throws IOException {
        NovaTemplateOptions options = NovaTemplateOptions.Builder.installPrivateKey((String)"-----BEGIN RSA PRIVATE KEY-----");
        Assert.assertEquals((String)options.getPrivateKey(), (String)"-----BEGIN RSA PRIVATE KEY-----");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testinstallPrivateKeyNPE() {
        NovaTemplateOptions.Builder.installPrivateKey(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testauthorizePublicKeyBadFormat() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        options.authorizePublicKey("whompy");
    }

    @Test
    public void testauthorizePublicKey() throws IOException {
        NovaTemplateOptions options = new NovaTemplateOptions();
        options.authorizePublicKey("ssh-rsa");
        Assert.assertEquals((String)options.getPublicKey(), (String)"ssh-rsa");
    }

    @Test
    public void testNullauthorizePublicKey() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        Assert.assertEquals((String)options.getPublicKey(), null);
    }

    @Test
    public void testauthorizePublicKeyStatic() throws IOException {
        NovaTemplateOptions options = NovaTemplateOptions.Builder.authorizePublicKey((String)"ssh-rsa");
        Assert.assertEquals((String)options.getPublicKey(), (String)"ssh-rsa");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testauthorizePublicKeyNPE() {
        NovaTemplateOptions.Builder.authorizePublicKey(null);
    }

    @Test
    public void testUserData() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        options.userData("test".getBytes());
        Assert.assertEquals((String)new String(options.getUserData()), (String)"test");
    }

    @Test
    public void testDiskConfig() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        options.diskConfig("AUTO");
        Assert.assertEquals((String)options.getDiskConfig(), (String)"AUTO");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testblockOnPortBadFormat() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        options.blockOnPort(-1, -1);
    }

    @Test
    public void testblockOnPort() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        options.blockOnPort(22, 30);
        Assert.assertEquals((int)options.getPort(), (int)22);
        Assert.assertEquals((int)options.getSeconds(), (int)30);
    }

    @Test
    public void testNullblockOnPort() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        Assert.assertEquals((int)options.getPort(), (int)-1);
        Assert.assertEquals((int)options.getSeconds(), (int)-1);
    }

    @Test
    public void testblockOnPortStatic() {
        NovaTemplateOptions options = NovaTemplateOptions.Builder.blockOnPort((int)22, (int)30);
        Assert.assertEquals((int)options.getPort(), (int)22);
        Assert.assertEquals((int)options.getSeconds(), (int)30);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testinboundPortsBadFormat() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        options.inboundPorts(new int[]{-1, -1});
    }

    @Test
    public void testinboundPorts() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        options.inboundPorts(new int[]{22, 30});
        Assert.assertEquals((int)options.getInboundPorts()[0], (int)22);
        Assert.assertEquals((int)options.getInboundPorts()[1], (int)30);
    }

    @Test
    public void testDefaultOpen22() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        Assert.assertEquals((int)options.getInboundPorts()[0], (int)22);
    }

    @Test
    public void testinboundPortsStatic() {
        NovaTemplateOptions options = NovaTemplateOptions.Builder.inboundPorts((int[])new int[]{22, 30});
        Assert.assertEquals((int)options.getInboundPorts()[0], (int)22);
        Assert.assertEquals((int)options.getInboundPorts()[1], (int)30);
    }
}

