/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.extensions.FlavorExtraSpecsApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="FlavorExtraSpecsApiExpectTest")
public class FlavorExtraSpecsApiExpectTest
extends BaseNovaApiExpectTest {
    public void testGetAllExtraSpecs() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/flavors/9/os-extra_specs");
        FlavorExtraSpecsApi api = (FlavorExtraSpecsApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/volume_type_extra_specs.json"))).build())).getFlavorExtraSpecsExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertEquals((Map)api.getMetadata("9"), (Map)ImmutableMap.of((Object)"test", (Object)"value1"));
    }

    public void testGetAllExtraSpecsFailNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/flavors/9/os-extra_specs");
        FlavorExtraSpecsApi api = (FlavorExtraSpecsApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getFlavorExtraSpecsExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.getMetadata("9").isEmpty());
    }

    public void testSetAllExtraSpecs() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/flavors/9/os-extra_specs");
        FlavorExtraSpecsApi api = (FlavorExtraSpecsApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(FlavorExtraSpecsApiExpectTest.payloadFromStringWithContentType((String)"{\"extra_specs\":{\"test1\":\"somevalue\"}}", (String)"application/json"))).build(), HttpResponse.builder().statusCode(200).build())).getFlavorExtraSpecsExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.updateMetadata("9", (Map)ImmutableMap.of((Object)"test1", (Object)"somevalue")));
    }

    public void testSetExtraSpec() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/flavors/5/os-extra_specs/test1");
        FlavorExtraSpecsApi api = (FlavorExtraSpecsApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("PUT").payload(FlavorExtraSpecsApiExpectTest.payloadFromStringWithContentType((String)"{\"test1\":\"somevalue\"}", (String)"application/json"))).build(), HttpResponse.builder().statusCode(200).build())).getFlavorExtraSpecsExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.updateMetadataEntry("5", "test1", "somevalue"));
    }

    public void testGetExtraSpec() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/flavors/5/os-extra_specs/test1");
        FlavorExtraSpecsApi api = (FlavorExtraSpecsApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(FlavorExtraSpecsApiExpectTest.payloadFromStringWithContentType((String)"{\"test1\":\"another value\"}", (String)"application/json"))).build())).getFlavorExtraSpecsExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertEquals((String)api.getMetadataKey("5", "test1"), (String)"another value");
    }

    public void testGetExtraSpecFailNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/flavors/5/os-extra_specs/test1");
        FlavorExtraSpecsApi api = (FlavorExtraSpecsApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getFlavorExtraSpecsExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertNull((Object)api.getMetadataKey("5", "test1"));
    }

    public void testDeleteExtraSpec() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/flavors/5/os-extra_specs/test1");
        FlavorExtraSpecsApi api = (FlavorExtraSpecsApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), HttpResponse.builder().statusCode(200).build())).getFlavorExtraSpecsExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.deleteMetadataKey("5", "test1"));
    }

    public void testDeleteExtraSpecFailNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/flavors/5/os-extra_specs/test1");
        FlavorExtraSpecsApi api = (FlavorExtraSpecsApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), HttpResponse.builder().statusCode(404).build())).getFlavorExtraSpecsExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertFalse((boolean)api.deleteMetadataKey("5", "test1"));
    }
}

