/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.extensions.FlavorExtraSpecsApi;
import org.jclouds.openstack.nova.v2_0.features.FlavorApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiLiveTest;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="FlavorExtraSpecsApiLiveTest", singleThreaded=true)
public class FlavorExtraSpecsApiLiveTest
extends BaseNovaApiLiveTest {
    private FlavorApi flavorApi;
    private Optional<? extends FlavorExtraSpecsApi> apiOption;
    private String zone;
    private Resource testFlavor;
    private Map<String, String> testSpecs = ImmutableMap.of((Object)"jclouds-test", (Object)"some data", (Object)"jclouds-test2", (Object)"more data!");

    @Override
    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.zone = (String)Iterables.getLast((Iterable)((NovaApi)this.api).getConfiguredZones(), (Object)"nova");
        this.flavorApi = ((NovaApi)this.api).getFlavorApiForZone(this.zone);
        this.apiOption = ((NovaApi)this.api).getFlavorExtraSpecsExtensionForZone(this.zone);
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        if (this.apiOption.isPresent() && this.testFlavor != null) {
            for (String key : this.testSpecs.keySet()) {
                Assert.assertTrue((boolean)((FlavorExtraSpecsApi)this.apiOption.get()).deleteMetadataKey(this.testFlavor.getId(), key));
            }
        }
        super.tearDown();
    }

    public void testCreateExtraSpecs() {
        if (this.apiOption.isPresent()) {
            FlavorExtraSpecsApi api = (FlavorExtraSpecsApi)this.apiOption.get();
            this.testFlavor = (Resource)Iterables.getLast((Iterable)this.flavorApi.list().concat());
            Map before = api.getMetadata(this.testFlavor.getId());
            Assert.assertNotNull((Object)before);
            HashMap specs = Maps.newHashMap((Map)before);
            specs.putAll(this.testSpecs);
            Assert.assertTrue((boolean)api.updateMetadata(this.testFlavor.getId(), (Map)specs));
            Assert.assertEquals((Map)api.getMetadata(this.testFlavor.getId()), (Map)specs);
            for (Map.Entry entry : specs.entrySet()) {
                Assert.assertEquals((String)api.getMetadataKey(this.testFlavor.getId(), (String)entry.getKey()), (String)((String)entry.getValue()));
            }
        }
    }

    @Test(dependsOnMethods={"testCreateExtraSpecs"})
    public void testListExtraSpecs() {
        if (this.apiOption.isPresent()) {
            FlavorExtraSpecsApi api = (FlavorExtraSpecsApi)this.apiOption.get();
            for (String key : this.testSpecs.keySet()) {
                Assert.assertTrue((boolean)api.getMetadata(this.testFlavor.getId()).containsKey(key));
            }
            for (Resource flavor : this.flavorApi.list().concat()) {
                Map specs = api.getMetadata(flavor.getId());
                Assert.assertNotNull((Object)specs);
                for (Map.Entry entry : specs.entrySet()) {
                    Assert.assertEquals((String)api.getMetadataKey(flavor.getId(), (String)entry.getKey()), (String)((String)entry.getValue()));
                }
            }
        }
    }

    @Test(dependsOnMethods={"testCreateExtraSpecs"})
    public void testTwiddleIndividualSpecs() {
        if (this.apiOption.isPresent()) {
            FlavorExtraSpecsApi api = (FlavorExtraSpecsApi)this.apiOption.get();
            for (String key : this.testSpecs.keySet()) {
                Assert.assertTrue((boolean)api.updateMetadataEntry(this.testFlavor.getId(), key, "new value"));
            }
            for (String key : this.testSpecs.keySet()) {
                Assert.assertEquals((String)api.getMetadataKey(this.testFlavor.getId(), key), (String)"new value");
            }
            for (Resource flavor : this.flavorApi.list().concat()) {
                Map specs = api.getMetadata(flavor.getId());
                Assert.assertNotNull((Object)specs);
                for (Map.Entry entry : specs.entrySet()) {
                    Assert.assertEquals((String)api.getMetadataKey(flavor.getId(), (String)entry.getKey()), (String)((String)entry.getValue()));
                }
            }
        }
    }
}

