/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.extensions.FloatingIPApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseFloatingIPListTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseFloatingIPTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="FloatingIPApiExpectTest")
public class FloatingIPApiExpectTest
extends BaseNovaApiExpectTest {
    public void testWhenNamespaceInExtensionsListFloatingIpPresent() throws Exception {
        NovaApi apiWhenExtensionNotInList = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse);
        Assert.assertEquals((Set)apiWhenExtensionNotInList.getConfiguredZones(), (Set)ImmutableSet.of((Object)"az-1.region-a.geo-1", (Object)"az-2.region-a.geo-1", (Object)"az-3.region-a.geo-1"));
        Assert.assertTrue((boolean)apiWhenExtensionNotInList.getFloatingIPExtensionForZone("az-1.region-a.geo-1").isPresent());
    }

    public void testWhenNamespaceNotInExtensionsListFloatingIpNotPresent() throws Exception {
        NovaApi apiWhenExtensionNotInList = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.unmatchedExtensionsOfNovaResponse);
        Assert.assertEquals((Set)apiWhenExtensionNotInList.getConfiguredZones(), (Set)ImmutableSet.of((Object)"az-1.region-a.geo-1", (Object)"az-2.region-a.geo-1", (Object)"az-3.region-a.geo-1"));
        Assert.assertFalse((boolean)apiWhenExtensionNotInList.getFloatingIPExtensionForZone("az-1.region-a.geo-1").isPresent());
    }

    public void testListFloatingIPsWhenResponseIs2xx() throws Exception {
        HttpRequest list = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-floating-ips").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse listResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/floatingip_list.json"))).build();
        NovaApi apiWhenFloatingIPsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, list, listResponse);
        Assert.assertEquals((Set)apiWhenFloatingIPsExist.getConfiguredZones(), (Set)ImmutableSet.of((Object)"az-1.region-a.geo-1", (Object)"az-2.region-a.geo-1", (Object)"az-3.region-a.geo-1"));
        Assert.assertEquals((String)((FloatingIPApi)apiWhenFloatingIPsExist.getFloatingIPExtensionForZone("az-1.region-a.geo-1").get()).list().toString(), (String)new ParseFloatingIPListTest().expected().toString());
    }

    public void testListFloatingIPsWhenResponseIs404() throws Exception {
        HttpRequest list = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-floating-ips").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse listResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenNoServersExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, list, listResponse);
        Assert.assertTrue((boolean)((FloatingIPApi)apiWhenNoServersExist.getFloatingIPExtensionForZone("az-1.region-a.geo-1").get()).list().isEmpty());
    }

    public void testGetFloatingIPWhenResponseIs2xx() throws Exception {
        HttpRequest get = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-floating-ips/1").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse getResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/floatingip_details.json"))).build();
        NovaApi apiWhenFloatingIPsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, get, getResponse);
        Assert.assertEquals((String)((FloatingIPApi)apiWhenFloatingIPsExist.getFloatingIPExtensionForZone("az-1.region-a.geo-1").get()).get("1").toString(), (String)new ParseFloatingIPTest().expected().toString());
    }

    public void testGetFloatingIPWhenResponseIs404() throws Exception {
        HttpRequest get = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-floating-ips/1").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse getResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenNoServersExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, get, getResponse);
        Assert.assertNull((Object)((FloatingIPApi)apiWhenNoServersExist.getFloatingIPExtensionForZone("az-1.region-a.geo-1").get()).get("1"));
    }

    public void testAllocateWhenResponseIs2xx() throws Exception {
        HttpRequest createFloatingIP = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-floating-ips").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(FloatingIPApiExpectTest.payloadFromStringWithContentType((String)"{}", (String)"application/json"))).build();
        HttpResponse createFloatingIPResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/floatingip_details.json"))).build();
        NovaApi apiWhenFloatingIPsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, createFloatingIP, createFloatingIPResponse);
        Assert.assertEquals((String)((FloatingIPApi)apiWhenFloatingIPsExist.getFloatingIPExtensionForZone("az-1.region-a.geo-1").get()).create().toString(), (String)new ParseFloatingIPTest().expected().toString());
    }

    public void testAllocateWhenResponseIs404() throws Exception {
        HttpRequest createFloatingIP = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-floating-ips").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(FloatingIPApiExpectTest.payloadFromStringWithContentType((String)"{}", (String)"application/json"))).build();
        HttpResponse createFloatingIPResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenNoServersExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, createFloatingIP, createFloatingIPResponse);
        Assert.assertNull((Object)((FloatingIPApi)apiWhenNoServersExist.getFloatingIPExtensionForZone("az-1.region-a.geo-1").get()).create());
    }

    public void testAllocateWithPoolNameWhenResponseIs2xx() throws Exception {
        HttpRequest createFloatingIP = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-floating-ips").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(FloatingIPApiExpectTest.payloadFromStringWithContentType((String)"{\"pool\":\"myPool\"}", (String)"application/json"))).build();
        HttpResponse createFloatingIPResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/floatingip_details.json"))).build();
        NovaApi apiWhenFloatingIPsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, createFloatingIP, createFloatingIPResponse);
        Assert.assertEquals((String)((FloatingIPApi)apiWhenFloatingIPsExist.getFloatingIPExtensionForZone("az-1.region-a.geo-1").get()).allocateFromPool("myPool").toString(), (String)new ParseFloatingIPTest().expected().toString());
    }
}

