/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Address;
import org.jclouds.openstack.nova.v2_0.domain.FloatingIP;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.extensions.FloatingIPApi;
import org.jclouds.openstack.nova.v2_0.features.ServerApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="FloatingIPApiLiveTest")
public class FloatingIPApiLiveTest
extends BaseNovaApiLiveTest {
    private static final int INCONSISTENCY_WINDOW = 5000;

    @Test
    public void testListFloatingIPs() throws Exception {
        for (String zoneId : ((NovaApi)this.api).getConfiguredZones()) {
            Optional apiOption = ((NovaApi)this.api).getFloatingIPExtensionForZone(zoneId);
            if (!apiOption.isPresent()) continue;
            FloatingIPApi api = (FloatingIPApi)apiOption.get();
            ImmutableSet response = api.list().toSet();
            assert (null != response);
            Assert.assertTrue((response.size() >= 0 ? 1 : 0) != 0);
            for (FloatingIP ip : response) {
                FloatingIP newDetails = api.get(ip.getId());
                Assert.assertEquals((String)newDetails.getId(), (String)ip.getId());
                Assert.assertEquals((String)newDetails.getIp(), (String)ip.getIp());
                Assert.assertEquals((String)newDetails.getFixedIp(), (String)ip.getFixedIp());
                Assert.assertEquals((String)newDetails.getInstanceId(), (String)ip.getInstanceId());
            }
        }
    }

    @Test
    public void testAllocateAndDecreateFloatingIPs() throws Exception {
        for (String zoneId : ((NovaApi)this.api).getConfiguredZones()) {
            Optional apiOption = ((NovaApi)this.api).getFloatingIPExtensionForZone(zoneId);
            if (!apiOption.isPresent()) continue;
            FloatingIPApi api = (FloatingIPApi)apiOption.get();
            FloatingIP floatingIP = api.create();
            Assert.assertNotNull((Object)floatingIP);
            ImmutableSet response = api.list().toSet();
            boolean ipInSet = false;
            for (FloatingIP ip : response) {
                if (!ip.getId().equals(floatingIP.getId())) continue;
                ipInSet = true;
            }
            Assert.assertTrue((boolean)ipInSet);
            api.delete(floatingIP.getId());
            response = api.list().toSet();
            ipInSet = false;
            for (FloatingIP ip : response) {
                if (!ip.getId().equals(floatingIP.getId())) continue;
                ipInSet = true;
            }
            Assert.assertFalse((boolean)ipInSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddAndRemoveFloatingIp() throws Exception {
        for (String zoneId : ((NovaApi)this.api).getConfiguredZones()) {
            Optional apiOption = ((NovaApi)this.api).getFloatingIPExtensionForZone(zoneId);
            if (!apiOption.isPresent()) continue;
            FloatingIPApi api = (FloatingIPApi)apiOption.get();
            ServerApi serverApi = ((NovaApi)this.api).getServerApiForZone(zoneId);
            Server server = this.createServerInZone(zoneId);
            FloatingIP floatingIP = api.create();
            Assert.assertNotNull((Object)floatingIP);
            try {
                api.addToServer(floatingIP.getIp(), server.getId());
                FloatingIPApiLiveTest.assertEventually(new ServerHasFloatingIP(serverApi, server.getId(), floatingIP.getIp()));
            }
            finally {
                api.removeFromServer(floatingIP.getIp(), server.getId());
                serverApi.delete(server.getId());
            }
        }
    }

    protected static void assertEventually(Runnable assertion) {
        long start = System.currentTimeMillis();
        AssertionError error = null;
        for (int i = 0; i < 30; ++i) {
            try {
                assertion.run();
                if (i > 0) {
                    System.err.printf("%d attempts and %dms asserting %s%n", i + 1, System.currentTimeMillis() - start, assertion.getClass().getSimpleName());
                }
                return;
            }
            catch (AssertionError e) {
                error = e;
                try {
                    Thread.sleep(166L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                continue;
            }
        }
        if (error != null) {
            throw error;
        }
    }

    public static final class ServerHasFloatingIP
    implements Runnable {
        private final ServerApi api;
        private final String serverId;
        private final String floatingIP;

        public ServerHasFloatingIP(ServerApi serverApi, String serverId, String floatingIP) {
            this.api = serverApi;
            this.serverId = serverId;
            this.floatingIP = floatingIP;
        }

        @Override
        public void run() {
            try {
                Server server = this.api.get(this.serverId);
                boolean ipInServerAddresses = false;
                Multimap addresses = server.getAddresses();
                for (Address address : addresses.values()) {
                    if (!address.getAddr().equals(this.floatingIP)) continue;
                    ipInServerAddresses = true;
                }
                Assert.assertTrue((boolean)ipInServerAddresses);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

