/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Set;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Host;
import org.jclouds.openstack.nova.v2_0.domain.HostResourceUsage;
import org.jclouds.openstack.nova.v2_0.extensions.HostAdministrationApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="HostAdministrationApiExpectTest")
public class HostAdministrationApiExpectTest
extends BaseNovaApiExpectTest {
    public void testList() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-hosts");
        HostAdministrationApi api = (HostAdministrationApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/hosts_list.json"))).build())).getHostAdministrationExtensionForZone("az-1.region-a.geo-1").get();
        Host expected = Host.builder().name("ubuntu").service("compute").build();
        ImmutableSet result = api.list().toSet();
        Host host = (Host)Iterables.getOnlyElement((Iterable)result);
        Assert.assertEquals((String)host.getName(), (String)"ubuntu");
        Assert.assertEquals((String)host.getService(), (String)"compute");
        Assert.assertEquals((Object)host, (Object)expected);
    }

    public void testGet() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-hosts/xyz");
        HostAdministrationApi api = (HostAdministrationApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/host.json"))).build())).getHostAdministrationExtensionForZone("az-1.region-a.geo-1").get();
        ImmutableSet expected = ImmutableSet.of((Object)HostResourceUsage.builder().memoryMb(16083).project("(total)").cpu(4).diskGb(181).host("ubuntu").build(), (Object)HostResourceUsage.builder().memoryMb(3396).project("(used_now)").cpu(3).diskGb(5).host("ubuntu").build(), (Object)HostResourceUsage.builder().memoryMb(6144).project("(used_max)").cpu(3).diskGb(80).host("ubuntu").build(), (Object)HostResourceUsage.builder().memoryMb(6144).project("f8535069c3fb404cb61c873b1a0b4921").cpu(3).diskGb(80).host("ubuntu").build());
        Assert.assertEquals((Set)api.listResourceUsage("xyz").toSet(), (Set)expected);
    }

    public void testEnableHost() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-hosts/ubuntu");
        HostAdministrationApi api = (HostAdministrationApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(HostAdministrationApiExpectTest.payloadFromStringWithContentType((String)"{\"status\":\"enable\"}", (String)"application/json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(HostAdministrationApiExpectTest.payloadFromStringWithContentType((String)"{\"host\":\"ubuntu\",\"status\":\"enabled\"}", (String)"application/json"))).build())).getHostAdministrationExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.enable("ubuntu"));
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testEnableHostFailNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-hosts/ubuntu");
        HostAdministrationApi api = (HostAdministrationApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(HostAdministrationApiExpectTest.payloadFromStringWithContentType((String)"{\"status\":\"enable\"}", (String)"application/json"))).endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getHostAdministrationExtensionForZone("az-1.region-a.geo-1").get();
        api.enable("ubuntu");
    }

    public void testEnableHostFailNotEnabled() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-hosts/ubuntu");
        HostAdministrationApi api = (HostAdministrationApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(HostAdministrationApiExpectTest.payloadFromStringWithContentType((String)"{\"status\":\"enable\"}", (String)"application/json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(HostAdministrationApiExpectTest.payloadFromStringWithContentType((String)"{\"host\":\"ubuntu\",\"status\":\"disabled\"}", (String)"application/json"))).build())).getHostAdministrationExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertFalse((boolean)api.enable("ubuntu"));
    }

    public void testDisableHost() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-hosts/ubuntu");
        HostAdministrationApi api = (HostAdministrationApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(HostAdministrationApiExpectTest.payloadFromStringWithContentType((String)"{\"status\":\"disable\"}", (String)"application/json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(HostAdministrationApiExpectTest.payloadFromStringWithContentType((String)"{\"host\":\"ubuntu\",\"status\":\"disabled\"}", (String)"application/json"))).build())).getHostAdministrationExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.disable("ubuntu"));
    }

    public void testStartMaintenance() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-hosts/ubuntu");
        HostAdministrationApi api = (HostAdministrationApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(HostAdministrationApiExpectTest.payloadFromStringWithContentType((String)"{\"maintenance_mode\":\"enable\"}", (String)"application/json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(HostAdministrationApiExpectTest.payloadFromStringWithContentType((String)"{\"host\":\"ubuntu\",\"maintenance_mode\":\"on_maintenance\"}", (String)"application/json"))).build())).getHostAdministrationExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.startMaintenance("ubuntu"));
    }

    public void testStopMaintenance() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-hosts/ubuntu");
        HostAdministrationApi api = (HostAdministrationApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(HostAdministrationApiExpectTest.payloadFromStringWithContentType((String)"{\"maintenance_mode\":\"disable\"}", (String)"application/json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(HostAdministrationApiExpectTest.payloadFromStringWithContentType((String)"{\"host\":\"ubuntu\",\"maintenance_mode\":\"off_maintenance\"}", (String)"application/json"))).build())).getHostAdministrationExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.stopMaintenance("ubuntu"));
    }

    public void testStartupHost() {
        HostAdministrationApi api = (HostAdministrationApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-hosts/ubuntu/startup").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(HostAdministrationApiExpectTest.payloadFromStringWithContentType((String)"{\"host\":\"ubuntu\",\"power_action\":\"startup\"}", (String)"application/json"))).build())).getHostAdministrationExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.startup("ubuntu"));
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testStartupHostFailNotFound() {
        HostAdministrationApi api = (HostAdministrationApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-hosts/ubuntu/startup").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build(), HttpResponse.builder().statusCode(404).build())).getHostAdministrationExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.startup("ubuntu"));
    }

    public void testStartupHostFailWrongActionInProgress() {
        HostAdministrationApi api = (HostAdministrationApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-hosts/ubuntu/startup").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(HostAdministrationApiExpectTest.payloadFromStringWithContentType((String)"{\"host\":\"ubuntu\",\"power_action\":\"shutdown\"}", (String)"application/json"))).build())).getHostAdministrationExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertFalse((boolean)api.startup("ubuntu"));
    }

    public void testShutdownHost() {
        HostAdministrationApi api = (HostAdministrationApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-hosts/ubuntu/shutdown").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(HostAdministrationApiExpectTest.payloadFromStringWithContentType((String)"{\"host\":\"ubuntu\",\"power_action\":\"shutdown\"}", (String)"application/json"))).build())).getHostAdministrationExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.shutdown("ubuntu"));
    }

    public void testRebootHost() {
        HostAdministrationApi api = (HostAdministrationApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-hosts/ubuntu/reboot").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(HostAdministrationApiExpectTest.payloadFromStringWithContentType((String)"{\"host\":\"ubuntu\",\"power_action\":\"reboot\"}", (String)"application/json"))).build())).getHostAdministrationExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.reboot("ubuntu"));
    }
}

