/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.collect.FluentIterable;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.KeyPair;
import org.jclouds.openstack.nova.v2_0.extensions.KeyPairApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="KeyPairApiLiveTest")
public class KeyPairApiLiveTest
extends BaseNovaApiLiveTest {
    public void testListKeyPairs() throws Exception {
        for (String zoneId : ((NovaApi)this.api).getConfiguredZones()) {
            KeyPairApi keyPairApi = (KeyPairApi)((NovaApi)this.api).getKeyPairExtensionForZone(zoneId).get();
            FluentIterable keyPairsList = keyPairApi.list();
            Assert.assertNotNull((Object)keyPairsList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateAndDeleteKeyPair() throws Exception {
        String KEYPAIR_NAME = "testkp";
        for (String zoneId : ((NovaApi)this.api).getConfiguredZones()) {
            KeyPairApi keyPairApi = (KeyPairApi)((NovaApi)this.api).getKeyPairExtensionForZone(zoneId).get();
            KeyPair keyPair = null;
            try {
                keyPair = keyPairApi.create("testkp");
                Assert.assertNotNull((Object)keyPair);
            }
            finally {
                if (keyPair == null) continue;
                keyPairApi.delete("testkp");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateAndDeleteKeyPairWithPublicKey() throws Exception {
        String KEYPAIR_NAME = "testkp";
        String PUBLIC_KEY = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAAAgQCrrBREFxz3002l1HuXz0+UOdJQ/mOYD5DiJwwB/TOybwIKQJPOxJWA9gBoo4k9dthTKBTaEYbzrll7iZcp59E80S6mNiAr3mUgi+x5Y8uyXeJ2Ws+h6peVyFVUu9epkwpcTd1GVfdcVWsTajwDz9+lxCDhl0RZKDFoT0scTxbj/w== nova@nv-aw2az2-api0002";
        for (String zoneId : ((NovaApi)this.api).getConfiguredZones()) {
            KeyPairApi keyPairApi = (KeyPairApi)((NovaApi)this.api).getKeyPairExtensionForZone(zoneId).get();
            KeyPair keyPair = null;
            try {
                keyPair = keyPairApi.createWithPublicKey("testkp", "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAAAgQCrrBREFxz3002l1HuXz0+UOdJQ/mOYD5DiJwwB/TOybwIKQJPOxJWA9gBoo4k9dthTKBTaEYbzrll7iZcp59E80S6mNiAr3mUgi+x5Y8uyXeJ2Ws+h6peVyFVUu9epkwpcTd1GVfdcVWsTajwDz9+lxCDhl0RZKDFoT0scTxbj/w== nova@nv-aw2az2-api0002");
                Assert.assertNotNull((Object)keyPair);
            }
            finally {
                if (keyPair == null) continue;
                keyPairApi.delete("testkp");
            }
        }
    }
}

