/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import java.net.URI;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Quota;
import org.jclouds.openstack.nova.v2_0.extensions.QuotaApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="QuotaApiExpectTest")
public class QuotaApiExpectTest
extends BaseNovaApiExpectTest {
    public void testGetQuotas() throws Exception {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-quota-sets/demo");
        QuotaApi api = (QuotaApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/quotas.json"))).build())).getQuotaExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertEquals((Object)api.getByTenant("demo"), (Object)QuotaApiExpectTest.getTestQuotas());
    }

    public void testGetQuotasFailsTenantNotFound() throws Exception {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-quota-sets/demo");
        QuotaApi api = (QuotaApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getQuotaExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertNull((Object)api.getByTenant("demo"));
    }

    public void testGetDefaultQuotas() throws Exception {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-quota-sets/demo/defaults");
        QuotaApi api = (QuotaApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/quotas.json"))).build())).getQuotaExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertEquals((Object)api.getDefaultsForTenant("demo"), (Object)QuotaApiExpectTest.getTestQuotas());
    }

    public void testGetDefaultQuotasFailsTenantNotFound() throws Exception {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-quota-sets/demo/defaults");
        QuotaApi api = (QuotaApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getQuotaExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertNull((Object)api.getDefaultsForTenant("demo"));
    }

    public void testUpdateQuotas() throws Exception {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-quota-sets/demo");
        QuotaApi api = (QuotaApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().endpoint(endpoint).method("PUT").addHeader("X-Auth-Token", new String[]{this.authToken})).payload(this.payloadFromResourceWithContentType("/quotas.json", "application/json"))).build(), HttpResponse.builder().statusCode(200).build())).getQuotaExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.updateQuotaOfTenant(QuotaApiExpectTest.getTestQuotas(), "demo"));
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testUpdateQuotasFailsNotFound() throws Exception {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-quota-sets/demo");
        QuotaApi api = (QuotaApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().endpoint(endpoint).method("PUT").addHeader("X-Auth-Token", new String[]{this.authToken})).payload(this.payloadFromResourceWithContentType("/quotas.json", "application/json"))).build(), HttpResponse.builder().statusCode(404).build())).getQuotaExtensionForZone("az-1.region-a.geo-1").get();
        api.updateQuotaOfTenant(QuotaApiExpectTest.getTestQuotas(), "demo");
    }

    public static Quota getTestQuotas() {
        return Quota.builder().metadataItems(128).injectedFileContentBytes(10240).injectedFiles(5).gigabytes(1000).ram(51200).floatingIps(10).securityGroups(10).securityGroupRules(20).instances(10).keyPairs(100).volumes(10).cores(20).id("demo").build();
    }
}

