/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.QuotaClass;
import org.jclouds.openstack.nova.v2_0.extensions.QuotaClassApi;
import org.jclouds.openstack.nova.v2_0.extensions.QuotaClassApiExpectTest;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="QuotaClassApiLiveTest", singleThreaded=true)
public class QuotaClassApiLiveTest
extends BaseNovaApiLiveTest {
    private Optional<? extends QuotaClassApi> apiOption;
    private String zone;

    @Override
    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.zone = (String)Iterables.getLast((Iterable)((NovaApi)this.api).getConfiguredZones(), (Object)"nova");
        this.apiOption = ((NovaApi)this.api).getQuotaClassExtensionForZone(this.zone);
    }

    public void testUpdateAndGetQuotaClass() {
        if (this.apiOption.isPresent()) {
            QuotaClassApi api = (QuotaClassApi)this.apiOption.get();
            QuotaClass firstVersion = ((QuotaClass.Builder)((QuotaClass.Builder)((QuotaClass.Builder)((QuotaClass.Builder)((QuotaClass.Builder)QuotaClassApiExpectTest.getTestQuotas().toBuilder().id("jcloudstestquotas")).cores(10)).instances(5)).ram(4096)).volumes(5)).build();
            Assert.assertTrue((boolean)api.update(firstVersion.getId(), firstVersion));
            Assert.assertEquals((Object)api.get(firstVersion.getId()), (Object)firstVersion);
            QuotaClass secondVersion = ((QuotaClass.Builder)firstVersion.toBuilder().ram(8192)).build();
            Assert.assertTrue((boolean)api.update(secondVersion.getId(), secondVersion));
            Assert.assertEquals((Object)api.get(secondVersion.getId()), (Object)secondVersion);
        }
    }
}

